/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation;

import org.multiverse.instrumentation.Clazz;
import org.multiverse.instrumentation.Environment;
import org.multiverse.instrumentation.InstrumentationPhase;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.InstrumenterLogger;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public abstract class AbstractInstrumentationPhase
implements InstrumentationPhase {
    private final String name;

    public AbstractInstrumentationPhase(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Clazz instrument(Environment environment, Clazz originalClazz) {
        InstrumenterLogger log = environment.getLog();
        log.lessImportant("   Multiverse: %s: instrumenting class %s", this.name, originalClazz.getName());
        this.doInit();
        return this.doInstrument(environment, originalClazz);
    }

    public String toString() {
        return this.name;
    }

    protected void doInit() {
    }

    protected abstract Clazz doInstrument(Environment var1, Clazz var2);
}

