/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.javaagent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.multiverse.instrumentation.Clazz;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.Instrumentor;
import org.multiverse.javaagent.JavaAgentProblemMonitor;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class MultiverseClassFileTransformer
implements ClassFileTransformer {
    private static final Logger logger = Logger.getLogger(MultiverseClassFileTransformer.class.getName());
    private final Instrumentor compiler;

    public MultiverseClassFileTransformer(Instrumentor compiler) {
        if (compiler == null) {
            throw new NullPointerException();
        }
        this.compiler = compiler;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytecode) throws IllegalClassFormatException {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("Instrumenting class %s", className));
            }
            Clazz originalClazz = new Clazz(className);
            originalClazz.setBytecode(bytecode);
            originalClazz.setClassLoader(loader);
            Clazz resultClazz = this.compiler.process(originalClazz);
            return originalClazz == resultClazz ? null : resultClazz.getBytecode();
        }
        catch (RuntimeException ex) {
            MultiverseClassFileTransformer.handleThrowable(className, ex);
            throw ex;
        }
        catch (Error ex) {
            MultiverseClassFileTransformer.handleThrowable(className, ex);
            throw ex;
        }
    }

    private static void handleThrowable(String className, Throwable cause) {
        String msg = String.format("Failed while instrumenting class '%s'. It is not possible to abort the Javaagent instrumentation process, so the JVM is going to continue, but since this class is not instrumented, it is not transactional so all bets are off.", className);
        logger.log(Level.SEVERE, msg, cause);
        JavaAgentProblemMonitor.INSTANCE.signalProblem(className);
    }
}

