/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.javaagent;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.multiverse.MultiverseConstants;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.Instrumentor;
import org.multiverse.instrumentation.SystemOutImportantInstrumenterLogger;
import org.multiverse.javaagent.JavaAgentFiler;
import org.multiverse.javaagent.MultiverseClassFileTransformer;
import org.multiverse.utils.SystemOut;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class MultiverseJavaAgent
implements MultiverseConstants {
    public static final String KEY = "org.multiverse.javaagent.instrumentor";

    public static void premain(String agentArgs, Instrumentation inst) throws UnmodifiableClassException {
        MultiverseJavaAgent.printMultiverseJavaAgentInfo();
        Instrumentor compiler = MultiverseJavaAgent.loadClazzCompiler();
        inst.addTransformer(new MultiverseClassFileTransformer(compiler));
        SystemOut.println("Multiverse: Multiverse Javaagent started successfully", new Object[0]);
    }

    private static Instrumentor loadClazzCompiler() {
        Instrumentor instrumentor = MultiverseJavaAgent.createInstrumentor();
        boolean verbose = MultiverseJavaAgent.getSystemBooleanProperty("verbose", false);
        if (verbose) {
            instrumentor.setLog(new SystemOutImportantInstrumenterLogger());
            SystemOut.println("Multiverse: Verbose output enabled", new Object[0]);
        }
        instrumentor.setFiler(new JavaAgentFiler());
        boolean dumpBytecode = MultiverseJavaAgent.getSystemBooleanProperty("dumpBytecode", false);
        instrumentor.setDumpBytecode(dumpBytecode);
        if (dumpBytecode) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            File dumpDirectory = new File(MultiverseJavaAgent.getSystemProperty("dumpDirectory", tmpDir));
            SystemOut.println(String.format("Multiverse: Bytecode from Javaagent will be dumped to '%s'", dumpDirectory.getAbsolutePath()), new Object[0]);
            instrumentor.setDumpDirectory(dumpDirectory);
        }
        String include = MultiverseJavaAgent.include();
        instrumentor.include(include);
        if (instrumentor.getIncluded().equals("")) {
            SystemOut.println("Multiverse: All classes are included since nothing explicitly is configured.", new Object[0]);
            SystemOut.println("Multiverse: \tIn most cases you want to set it explicitly using the org.multiverse.javaagent.include System propery.", new Object[0]);
        } else {
            SystemOut.println("Multiverse: The following classes are included the instrumentation '%s'" + instrumentor.getIncluded(), new Object[0]);
        }
        String exclude = MultiverseJavaAgent.exclude();
        instrumentor.exclude(exclude);
        SystemOut.println("Multiverse: The following classes are excluded from instrumentation (exclude overrides includes) " + instrumentor.getExcluded(), new Object[0]);
        return instrumentor;
    }

    private static String exclude() {
        return MultiverseJavaAgent.normalize(MultiverseJavaAgent.getSystemProperty("exclude", ""));
    }

    private static String include() {
        return MultiverseJavaAgent.normalize(MultiverseJavaAgent.getSystemProperty("include", ""));
    }

    private static String normalize(String s) {
        return s.replace(",", ";").replace(":", ";");
    }

    private static void printMultiverseJavaAgentInfo() {
        SystemOut.println("Multiverse: Starting Multiverse JavaAgent", new Object[0]);
        SystemOut.println("Multiverse: Optimizations disabled in Javaaagent (see compiletime instrumentation)", new Object[0]);
        if (___BUGSHAKER_ENABLED) {
            SystemOut.println("Multiverse: Bugshaker enabled (can cause performance problems)", new Object[0]);
        } else {
            SystemOut.println("Multiverse: Bugshaker disabled (good performance)", new Object[0]);
        }
        if (___TRACING_ENABLED) {
            SystemOut.println("Multiverse: Tracing is enabled (useful for debugging/developing)", new Object[0]);
        } else {
            SystemOut.println("Multiverse: Tracing is disabled (useful for production environment)", new Object[0]);
        }
    }

    private static Instrumentor createInstrumentor() {
        String instrumentorClassName = MultiverseJavaAgent.getSystemProperty("instrumentor", "org.multiverse.stms.alpha.instrumentation.AlphaStmInstrumentor");
        SystemOut.println(String.format("Multiverse: Initializing instrumentor '%s'", instrumentorClassName), new Object[0]);
        Constructor constructor = MultiverseJavaAgent.getMethod(instrumentorClassName);
        try {
            Instrumentor instrumentor = (Instrumentor)constructor.newInstance(new Object[0]);
            SystemOut.println("Multiverse: Initialized '%s-%s'", instrumentor.getName(), instrumentor.getVersion());
            return instrumentor;
        }
        catch (IllegalAccessException e) {
            String msg = String.format("Failed to initialize Instrumentor through System property '%s' with value '%s'.The constructor is not accessable.", KEY, instrumentorClassName);
            throw new IllegalArgumentException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("Failed to initialize Instrumentor through System property '%s' with value '%s'.The constructor threw an exception.", KEY, instrumentorClassName);
            SystemOut.println(msg, new Object[0]);
            throw new IllegalArgumentException(msg, e);
        }
        catch (InstantiationException e) {
            String msg = String.format("Failed to initialize Instrumentor through System property '%s' with value '%s'.The class could not be instantiated.", KEY, instrumentorClassName);
            SystemOut.println(msg, new Object[0]);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static boolean getSystemBooleanProperty(String property, boolean defaultValue) {
        String value = MultiverseJavaAgent.getSystemProperty(property, "" + defaultValue);
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        String msg = String.format("property %s with value '%s' is not a boolean (true/false).", property, value);
        throw new IllegalArgumentException(msg);
    }

    private static String getSystemProperty(String property, String defaultValue) {
        String fullProperty = "org.multiverse.javaagent." + property;
        return System.getProperty(fullProperty, defaultValue);
    }

    private static Constructor getMethod(String className) {
        Constructor<?> method;
        Class<?> compilerClazz;
        try {
            compilerClazz = ClassLoader.getSystemClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Failed to initialize Instrumentor through System property '%s' with value '%s'.is not an existing class (it can't be found using the Thread.currentThread.getContextClassLoader).", KEY, className);
            SystemOut.println(msg, new Object[0]);
            throw new IllegalArgumentException(msg, e);
        }
        if (!Instrumentor.class.isAssignableFrom(compilerClazz)) {
            String msg = String.format("Failed to initialize Instrumentor through System property '%s' with value '%s'.is not an subclass of org.multiverse.compiler.Instrumentor).", KEY, className);
            SystemOut.println(msg, new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        try {
            method = compilerClazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = String.format("Failed to initialize Instrumentor through System property '%s' with value '%s'.Because a no arg constructor is not found.", KEY, compilerClazz);
            SystemOut.println(msg, new Object[0]);
            throw new IllegalArgumentException(msg, e);
        }
        return method;
    }
}

