/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import org.multiverse.api.TraceLevel;
import org.multiverse.api.backoff.BackoffPolicy;
import org.multiverse.api.backoff.ExponentialBackoffPolicy;
import org.multiverse.api.clock.PrimitiveClock;
import org.multiverse.api.clock.RelaxedPrimitiveClock;
import org.multiverse.api.clock.StrictPrimitiveClock;
import org.multiverse.api.commitlock.CommitLockPolicy;
import org.multiverse.api.commitlock.GenericCommitLockPolicy;
import org.multiverse.instrumentation.InstrumentationStamp;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class AlphaStmConfig {
    public int maxReadSpinCount = 50;
    public PrimitiveClock clock = new RelaxedPrimitiveClock();
    public CommitLockPolicy commitLockPolicy = GenericCommitLockPolicy.FAIL_FAST_BUT_RETRY;
    public BackoffPolicy backoffPolicy = ExponentialBackoffPolicy.INSTANCE_100_MS_MAX;
    public boolean quickReleaseWriteLocksEnabled = true;
    public boolean speculativeConfigurationEnabled = false;
    public int maxRetries = 1000;
    public int maxFixedUpdateSize = 20;
    public boolean optimizedConflictDetectionEnabled = true;
    public boolean dirtyCheckEnabled = true;
    public boolean explicitRetryAllowed = true;
    public boolean readTrackingEnabled = false;
    public boolean allowWriteSkew = true;
    public boolean interruptible = false;
    public TraceLevel traceLevel = TraceLevel.none;

    public static AlphaStmConfig createDebugConfig() {
        AlphaStmConfig config = new AlphaStmConfig();
        config.speculativeConfigurationEnabled = false;
        config.optimizedConflictDetectionEnabled = false;
        config.quickReleaseWriteLocksEnabled = false;
        config.clock = new StrictPrimitiveClock();
        return config;
    }

    public static AlphaStmConfig createFastConfig() {
        AlphaStmConfig config = new AlphaStmConfig();
        config.optimizedConflictDetectionEnabled = true;
        config.speculativeConfigurationEnabled = true;
        config.quickReleaseWriteLocksEnabled = true;
        config.clock = new RelaxedPrimitiveClock();
        return config;
    }

    public void ensureValid() {
        if (this.maxRetries < 0) {
            throw new IllegalStateException("Invalid configuration, 'maxRetries' can't be smaller than 0");
        }
        if (this.commitLockPolicy == null) {
            throw new IllegalStateException("Invalid configuration, 'commitLockPolicy' can't be null");
        }
        if (this.clock == null) {
            throw new IllegalStateException("Invalid configuration, 'clock' can't be null");
        }
        if (this.backoffPolicy == null) {
            throw new IllegalStateException("Invalid configuration, 'backoffPolicy' can't be null");
        }
        if (this.maxFixedUpdateSize < 0) {
            throw new IllegalStateException("Invalid configuration, fixedLengthMaximumSize can't be smaller than 0");
        }
        if (this.maxRetries < 0) {
            throw new IllegalStateException("Invalid configuration, defaultMaxRetryCount can't be smaller than 0");
        }
        if (this.maxReadSpinCount < 0) {
            throw new IllegalStateException("Invalid configuration, maxReadSprinCount can't be smaller than 0");
        }
        if (this.traceLevel == null) {
            throw new IllegalStateException("Invalid configuration, traceLevel can't be null");
        }
    }
}

