/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.FieldMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.repackaged.org.objectweb.asm.MethodAdapter;
import org.multiverse.repackaged.org.objectweb.asm.MethodVisitor;
import org.multiverse.repackaged.org.objectweb.asm.Opcodes;
import org.multiverse.repackaged.org.objectweb.asm.Type;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class NonTransactionalMethodFieldAccessMethodAdapter
extends MethodAdapter
implements Opcodes {
    private final MetadataRepository metadataRepository;
    private final ClassLoader classLoader;

    public NonTransactionalMethodFieldAccessMethodAdapter(ClassLoader classLoader, MethodVisitor mv, MetadataRepository metadataRepository) {
        super(mv);
        this.metadataRepository = metadataRepository;
        this.classLoader = classLoader;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String fieldName, String valueDesc) {
        block11: {
            block10: {
                ClassMetadata ownerMetadata = this.metadataRepository.loadClassMetadata(this.classLoader, owner);
                FieldMetadata fieldMetadata = ownerMetadata.getFieldMetadata(fieldName);
                if (!fieldMetadata.isManagedField() || fieldMetadata.hasFieldGranularity()) break block10;
                switch (opcode) {
                    case 180: {
                        this.txObjectOnTopToTranlocal(owner, false);
                        this.mv.visitFieldInsn(180, ownerMetadata.getTranlocalName(), fieldName, valueDesc);
                        break block11;
                    }
                    case 181: {
                        if (AsmUtils.isCategory2(valueDesc)) {
                            this.mv.visitInsn(93);
                            this.mv.visitInsn(88);
                        } else {
                            this.mv.visitInsn(95);
                        }
                        this.txObjectOnTopToTranlocal(owner, true);
                        if (AsmUtils.isCategory2(valueDesc)) {
                            this.mv.visitInsn(91);
                            this.mv.visitInsn(87);
                        } else {
                            this.mv.visitInsn(95);
                        }
                        this.mv.visitFieldInsn(181, ownerMetadata.getTranlocalName(), fieldName, valueDesc);
                        break block11;
                    }
                    case 178: {
                        throw new RuntimeException(String.format("GETSTATIC on instance field %s.%s not possible", owner, fieldName));
                    }
                    case 179: {
                        throw new RuntimeException(String.format("PUTSTATIC on instance field %s.%s not possible", owner, fieldName));
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            this.mv.visitFieldInsn(opcode, owner, fieldName, valueDesc);
        }
    }

    private void txObjectOnTopToTranlocal(String txObjectName, boolean write) {
        if (txObjectName.contains("__")) {
            throw new RuntimeException("No generated classes are allowed: " + txObjectName);
        }
        super.visitMethodInsn(184, Type.getInternalName(ThreadLocalTransaction.class), "getRequiredThreadLocalTransaction", String.format("()%s", Type.getDescriptor(Transaction.class)));
        super.visitInsn(95);
        super.visitTypeInsn(192, txObjectName);
        String openMethod = write ? "openForWrite" : "openForRead";
        super.visitMethodInsn(185, Type.getInternalName(AlphaTransaction.class), openMethod, String.format("(%s)%s", Type.getDescriptor(AlphaTransactionalObject.class), Type.getDescriptor(AlphaTranlocal.class)));
        String tranlocalName = this.metadataRepository.loadClassMetadata(this.classLoader, txObjectName).getTranlocalName();
        super.visitTypeInsn(192, tranlocalName);
    }
}

