/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import java.io.File;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Listeners;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.api.programmatic.ProgrammaticRef;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.mixins.BasicMixin;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.templates.TransactionTemplate;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class AlphaProgrammaticRef<E>
extends BasicMixin
implements ProgrammaticRef<E> {
    private static final TransactionFactory getOrAwaitTxFactory = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setReadonly(true).setFamilyName(AlphaProgrammaticRef.class.getName() + ".getOrAwait()").setReadTrackingEnabled(true).build();
    private final AlphaStm stm;

    public static AlphaProgrammaticRef createUncommitted() {
        return new AlphaProgrammaticRef((File)null);
    }

    public AlphaProgrammaticRef() {
        this(ThreadLocalTransaction.getThreadLocalTransaction(), null);
    }

    private AlphaProgrammaticRef(File file) {
        this.stm = null;
    }

    public AlphaProgrammaticRef(E value) {
        this(ThreadLocalTransaction.getThreadLocalTransaction(), value);
    }

    public AlphaProgrammaticRef(Transaction tx) {
        this(tx, null);
    }

    public AlphaProgrammaticRef(AlphaStm stm, E value) {
        if (stm == null) {
            throw new NullPointerException();
        }
        this.stm = stm;
        long writeVersion = this.stm.getVersion();
        AlphaProgrammaticRefTranlocal tranlocal = new AlphaProgrammaticRefTranlocal(this);
        tranlocal.value = value;
        this.___storeInitial(tranlocal, writeVersion);
    }

    public AlphaProgrammaticRef(Transaction tx, E value) {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        AlphaTransaction alphaTx = (AlphaTransaction)tx;
        if (tx == null || tx.getStatus().isDead()) {
            long writeVersion = this.stm.getVersion();
            AlphaProgrammaticRefTranlocal tranlocal = new AlphaProgrammaticRefTranlocal(this);
            tranlocal.value = value;
            this.___storeInitial(tranlocal, writeVersion);
            return;
        }
        AlphaProgrammaticRefTranlocal tranlocal = (AlphaProgrammaticRefTranlocal)alphaTx.openForConstruction(this);
        tranlocal.value = value;
    }

    private AlphaProgrammaticRefTranlocal<E> openForRead(Transaction tx) {
        AlphaTransaction alphaTx = (AlphaTransaction)tx;
        return (AlphaProgrammaticRefTranlocal)alphaTx.openForRead(this);
    }

    private AlphaProgrammaticRefTranlocal<E> openForWrite(Transaction tx) {
        AlphaTransaction alphaTx = (AlphaTransaction)tx;
        return (AlphaProgrammaticRefTranlocal)alphaTx.openForWrite(this);
    }

    @Override
    public E get() {
        Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null || tx.getStatus().isDead()) {
            return this.atomicGet();
        }
        return this.get(tx);
    }

    @Override
    public E get(Transaction tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        AlphaProgrammaticRefTranlocal<E> tranlocal = this.openForRead(tx);
        return tranlocal.value;
    }

    @Override
    public E atomicGet() {
        AlphaProgrammaticRefTranlocal tranlocal = (AlphaProgrammaticRefTranlocal)this.___load();
        if (tranlocal == null) {
            throw new UncommittedReadConflict();
        }
        return tranlocal.value;
    }

    @Override
    public boolean isNull() {
        return this.get() == null;
    }

    @Override
    public boolean isNull(Transaction tx) {
        return this.get(tx) == null;
    }

    @Override
    public boolean atomicIsNull() {
        return this.atomicGet() == null;
    }

    @Override
    public E getOrAwait() {
        return this.getOrAwait(getOrAwaitTxFactory);
    }

    @Override
    public E getOrAwait(TransactionFactory txFactory) {
        return new TransactionTemplate<E>(txFactory){

            @Override
            public E execute(Transaction t) {
                return AlphaProgrammaticRef.this.getOrAwait(t);
            }
        }.execute();
    }

    @Override
    public E getOrAwait(Transaction tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        AlphaProgrammaticRefTranlocal<E> tranlocal = this.openForRead(tx);
        if (tranlocal.value == null) {
            StmUtils.retry();
        }
        return tranlocal.value;
    }

    @Override
    public E set(E newValue) {
        Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null || tx.getStatus().isDead()) {
            return this.atomicSet(newValue);
        }
        return this.set(tx, newValue);
    }

    @Override
    public E set(Transaction tx, E newValue) {
        if (tx == null) {
            throw new NullPointerException();
        }
        AlphaProgrammaticRefTranlocal<E> readonly = this.openForRead(tx);
        if (readonly.value == newValue) {
            return newValue;
        }
        AlphaProgrammaticRefTranlocal<E> tranlocal = this.openForWrite(tx);
        if (newValue == tranlocal.value) {
            return newValue;
        }
        Object oldValue = tranlocal.value;
        tranlocal.value = newValue;
        return oldValue;
    }

    @Override
    public E atomicSet(E newValue) {
        AlphaProgrammaticRefTranlocal committed = (AlphaProgrammaticRefTranlocal)this.___load();
        if (committed == null) {
            throw UncommittedReadConflict.createUncommittedReadConflict();
        }
        if (committed.value == newValue) {
            return newValue;
        }
        AlphaProgrammaticRefTranlocal newTranlocal = new AlphaProgrammaticRefTranlocal(this);
        newTranlocal.value = newValue;
        AlphaProgrammaticRefTranlocal lockOwner = newTranlocal;
        this.lock(lockOwner);
        AlphaProgrammaticRefTranlocal oldTranlocal = (AlphaProgrammaticRefTranlocal)this.___load();
        long writeVersion = this.stm.getClock().tick();
        Listeners listeners = this.___storeUpdate(newTranlocal, writeVersion, true);
        if (listeners != null) {
            listeners.openAll();
        }
        return oldTranlocal.value;
    }

    private void lock(Transaction lockOwner) {
        for (int attempt = 0; attempt <= this.stm.getMaxRetries(); ++attempt) {
            lockOwner.setAttempt(attempt);
            if (attempt == this.stm.getMaxRetries()) {
                throw new TooManyRetriesException();
            }
            if (this.___tryLock(lockOwner)) {
                return;
            }
            this.stm.getBackoffPolicy().delayedUninterruptible(lockOwner);
        }
    }

    @Override
    public boolean atomicCompareAndSet(E expected, E update) {
        AlphaProgrammaticRefTranlocal committed = (AlphaProgrammaticRefTranlocal)this.___load();
        if (committed == null) {
            throw new UncommittedReadConflict();
        }
        if (committed.value != expected) {
            return false;
        }
        if (committed.value == update) {
            return true;
        }
        AlphaProgrammaticRefTranlocal updateTranlocal = new AlphaProgrammaticRefTranlocal(this);
        updateTranlocal.value = update;
        AlphaProgrammaticRefTranlocal lockOwner = updateTranlocal;
        if (!this.___tryLock(lockOwner)) {
            return false;
        }
        AlphaProgrammaticRefTranlocal oldTranlocal = (AlphaProgrammaticRefTranlocal)this.___load();
        if (oldTranlocal.value != expected) {
            this.___releaseLock(lockOwner);
            return false;
        }
        long writeVersion = this.stm.getClock().tick();
        Listeners listeners = this.___storeUpdate(updateTranlocal, writeVersion, true);
        if (listeners != null) {
            listeners.openAll();
        }
        return true;
    }

    public String toString() {
        E value = this.get();
        return this.toString(value);
    }

    @Override
    public String toString(Transaction tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        AlphaProgrammaticRefTranlocal<E> tranlocal = this.openForRead(tx);
        return this.toString(tranlocal.value);
    }

    private String toString(E value) {
        if (value == null) {
            return "AlphaProgrammaticRef(reference=null)";
        }
        return String.format("AlphaProgrammaticRef(reference=%s)", value);
    }

    @Override
    public AlphaProgrammaticRefTranlocal<E> ___openUnconstructed() {
        return new AlphaProgrammaticRefTranlocal(this);
    }
}

