/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.definition.AspectDefinition;

public final class AspectContext
implements Serializable {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private String m_name;
    private String m_qName;
    private transient WeakReference m_aspectClassRef;
    private DeploymentModel m_deploymentModel;
    private Map m_parameters = new HashMap();
    private Map m_metaData = new HashMap();
    private String m_uuid;
    private transient AspectDefinition m_aspectDefinition;
    private transient Object m_associatedObject;

    public AspectContext(String uuid, Class aspectClass, String name, DeploymentModel deploymentModel, AspectDefinition aspectDef, Map parameters, Object associated) {
        this.m_uuid = uuid;
        this.m_aspectClassRef = new WeakReference<Class>(aspectClass);
        this.m_name = name;
        this.m_qName = aspectDef.getQualifiedName();
        this.m_deploymentModel = deploymentModel;
        this.m_aspectDefinition = aspectDef;
        if (parameters != null) {
            this.m_parameters = parameters;
        }
        this.m_associatedObject = associated;
    }

    public String getUuid() {
        return this.m_uuid;
    }

    public String getName() {
        return this.m_name;
    }

    public DeploymentModel getDeploymentModel() {
        return this.m_deploymentModel;
    }

    public Class getAspectClass() {
        return (Class)this.m_aspectClassRef.get();
    }

    public AspectDefinition getAspectDefinition() {
        return this.m_aspectDefinition;
    }

    public void setParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }

    public String getParameter(String name) {
        return (String)this.m_parameters.get(name);
    }

    public void addMetaData(Object key, Object value) {
        this.m_metaData.put(key, value);
    }

    public Object getMetaData(Object key) {
        return this.m_metaData.get(key);
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_uuid = (String)fields.get("m_uuid", null);
        this.m_name = (String)fields.get("m_name", null);
        this.m_qName = (String)fields.get("m_qName", null);
        Class<?> aspectClass = Class.forName(this.m_name);
        this.m_aspectClassRef = new WeakReference(aspectClass);
        this.m_deploymentModel = (DeploymentModel)fields.get("m_deploymentModel", DeploymentModel.PER_JVM);
        this.m_parameters = (Map)fields.get("m_parameters", new HashMap());
        this.m_metaData = (Map)fields.get("m_metaData", new HashMap());
    }

    public Object getAssociatedObject() {
        return this.m_associatedObject;
    }
}

