/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.annotation;

import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.annotation.AsmAnnotations;
import org.codehaus.aspectwerkz.annotation.AspectAnnotationParser;
import org.codehaus.aspectwerkz.annotation.Mixin;
import org.codehaus.aspectwerkz.definition.MixinDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.reflect.ClassInfo;

public class MixinAnnotationParser {
    private static final MixinAnnotationParser INSTANCE = new MixinAnnotationParser();

    private MixinAnnotationParser() {
    }

    public static void parse(ClassInfo classInfo, MixinDefinition mixinDef) {
        INSTANCE.doParse(classInfo, mixinDef);
    }

    private void doParse(ClassInfo classInfo, MixinDefinition mixinDef) {
        if (classInfo == null) {
            throw new IllegalArgumentException("class to parse can not be null");
        }
        if (classInfo == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        SystemDefinition systemDef = mixinDef.getSystemDefinition();
        Mixin annotation = (Mixin)((Object)AsmAnnotations.getAnnotation("org.codehaus.aspectwerkz.annotation.Mixin", classInfo));
        if (annotation != null) {
            String expression = AspectAnnotationParser.getExpressionElseValue(annotation.value(), annotation.pointcut());
            ExpressionInfo expressionInfo = new ExpressionInfo(expression, systemDef.getUuid());
            ExpressionNamespace.getNamespace(systemDef.getUuid()).addExpressionInfo("AW_" + expression.hashCode(), expressionInfo);
            mixinDef.addExpressionInfo(expressionInfo);
            mixinDef.setTransient(annotation.isTransient());
            if (annotation.deploymentModel() != null) {
                mixinDef.setDeploymentModel(DeploymentModel.getDeploymentModelFor(annotation.deploymentModel()));
            }
        }
    }
}

