/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.aspect.container;

import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.aspect.container.AbstractAspectFactoryCompiler;
import org.codehaus.aspectwerkz.aspect.container.Artifact;
import org.codehaus.aspectwerkz.aspect.container.LazyPerXFactoryCompiler;
import org.codehaus.aspectwerkz.aspect.container.PerCflowXAspectFactoryCompiler;
import org.codehaus.aspectwerkz.aspect.container.PerJVMAspectFactoryCompiler;
import org.codehaus.aspectwerkz.aspect.container.PerObjectFactoryCompiler;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.util.ContextClassLoader;

public class AspectFactoryManager {
    public static String getAspectFactoryClassName(String aspectClassName, String aspectQualifiedName) {
        return aspectClassName.replace('.', '/') + "$" + aspectQualifiedName.replace('.', '/').replace('/', '_') + "_AWFactory";
    }

    public static void loadAspectFactory(String aspectFactoryJavaClassName, String uuid, String aspectClassName, String aspectQualifiedName, String containerClassName, String rawParameters, ClassLoader loader, String deploymentModelAsString) {
        try {
            ContextClassLoader.forName(loader, aspectFactoryJavaClassName);
        }
        catch (ClassNotFoundException e) {
            AbstractAspectFactoryCompiler compiler;
            DeploymentModel deploymentModel = DeploymentModel.getDeploymentModelFor(deploymentModelAsString);
            if (DeploymentModel.PER_JVM.equals(deploymentModel)) {
                compiler = new PerJVMAspectFactoryCompiler(uuid, aspectClassName, aspectQualifiedName, containerClassName, rawParameters, loader);
            } else if (DeploymentModel.PER_CLASS.equals(deploymentModel)) {
                compiler = new LazyPerXFactoryCompiler.PerClassAspectFactoryCompiler(uuid, aspectClassName, aspectQualifiedName, containerClassName, rawParameters, loader);
            } else if (DeploymentModel.PER_INSTANCE.equals(deploymentModel)) {
                compiler = new PerObjectFactoryCompiler.PerInstanceFactoryCompiler(uuid, aspectClassName, aspectQualifiedName, containerClassName, rawParameters, loader);
            } else if (DeploymentModel.PER_TARGET.equals(deploymentModel) || DeploymentModel.PER_THIS.equals(deploymentModel)) {
                compiler = new PerObjectFactoryCompiler(uuid, aspectClassName, aspectQualifiedName, containerClassName, rawParameters, loader);
            } else if (DeploymentModel.PER_CFLOW.equals(deploymentModel) || DeploymentModel.PER_CFLOWBELOW.equals(deploymentModel)) {
                compiler = new PerCflowXAspectFactoryCompiler(uuid, aspectClassName, aspectQualifiedName, containerClassName, rawParameters, loader);
            } else {
                throw new Error("Unimplemented " + deploymentModel);
            }
            Artifact artifact = compiler.compile();
            AsmHelper.defineClass(loader, artifact.bytecode, artifact.className);
        }
    }
}

