/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.aspectwerkz.hook.ClassLoaderPreProcessor;

public class ClassLoaderPatcher {
    public static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int b = is.read();
        while (b != -1) {
            os.write(b);
            b = is.read();
        }
        return os.toByteArray();
    }

    static byte[] getPatchedClassLoader(String preProcessorName) {
        byte[] abyte = null;
        InputStream is = null;
        try {
            is = ClassLoader.getSystemClassLoader().getParent().getResourceAsStream("java/lang/ClassLoader.class");
            abyte = ClassLoaderPatcher.inputStreamToByteArray(is);
        }
        catch (IOException e) {
            throw new Error("failed to read java.lang.ClassLoader: " + e.toString());
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
        if (preProcessorName != null) {
            try {
                ClassLoaderPreProcessor clpi = (ClassLoaderPreProcessor)Class.forName(preProcessorName).newInstance();
                abyte = clpi.preProcess(abyte);
            }
            catch (Exception e) {
                System.err.println("failed to instrument java.lang.ClassLoader: preprocessor not found");
                e.printStackTrace();
            }
        }
        return abyte;
    }

    private static void writeClass(String className, byte[] bytes, String dir) {
        String filename = dir + File.separatorChar + className.replace('.', File.separatorChar) + ".class";
        int pos = filename.lastIndexOf(File.separatorChar);
        if (pos > 0) {
            String finalDir = filename.substring(0, pos);
            new File(finalDir).mkdirs();
        }
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
            out.write(bytes);
            out.close();
        }
        catch (IOException e) {
            System.err.println("failed to write " + className + " in " + dir);
            e.printStackTrace();
        }
    }

    public static void patchClassLoader(String preProcessorName, String dir) {
        byte[] cl = ClassLoaderPatcher.getPatchedClassLoader(preProcessorName);
        ClassLoaderPatcher.writeClass("java.lang.ClassLoader", cl, dir);
    }
}

