/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.aspectwerkz.hook.ClassLoaderPatcher;
import org.codehaus.aspectwerkz.hook.ClassLoaderPreProcessor;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassReader;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;

public class ClassLoaderPreProcessorImpl
implements ClassLoaderPreProcessor {
    private static final String CLASSLOADER_CLASS_NAME = "java/lang/ClassLoader";
    private static final String DEFINECLASS0_METHOD_NAME = "defineClass0";
    private static final String DEFINECLASS1_METHOD_NAME = "defineClass1";
    private static final String DEFINECLASS2_METHOD_NAME = "defineClass2";
    private static final String DESC_CORE = "Ljava/lang/String;[BIILjava/security/ProtectionDomain;";
    private static final String DESC_PREFIX = "(Ljava/lang/String;[BIILjava/security/ProtectionDomain;";
    private static final String DESC_HELPER = "(Ljava/lang/ClassLoader;Ljava/lang/String;[BIILjava/security/ProtectionDomain;)[B";
    private static final String DESC_BYTEBUFFER_CORE = "Ljava/lang/String;Ljava/nio/ByteBuffer;IILjava/security/ProtectionDomain;";
    private static final String DESC_BYTEBUFFER_PREFIX = "(Ljava/lang/String;Ljava/nio/ByteBuffer;IILjava/security/ProtectionDomain;";
    private static final String DESC_BYTEBUFFER_HELPER = "(Ljava/lang/ClassLoader;Ljava/lang/String;Ljava/nio/ByteBuffer;IILjava/security/ProtectionDomain;)[B";

    public byte[] preProcess(byte[] classLoaderBytecode) {
        try {
            ClassWriter cw = new ClassWriter(true);
            ClassLoaderVisitor cv = new ClassLoaderVisitor(cw);
            ClassReader cr = new ClassReader(classLoaderBytecode);
            cr.accept(cv, false);
            return cw.toByteArray();
        }
        catch (Exception e) {
            System.err.println("failed to patch ClassLoader:");
            e.printStackTrace();
            return classLoaderBytecode;
        }
    }

    public static void main(String[] args) throws Exception {
        ClassLoaderPreProcessorImpl me = new ClassLoaderPreProcessorImpl();
        InputStream is = ClassLoader.getSystemClassLoader().getParent().getResourceAsStream("java/lang/ClassLoader.class");
        byte[] out = me.preProcess(ClassLoaderPatcher.inputStreamToByteArray(is));
        is.close();
        File dir = new File("_boot/java/lang/");
        dir.mkdirs();
        FileOutputStream os = new FileOutputStream("_boot/java/lang/ClassLoader.class");
        ((OutputStream)os).write(out);
        ((OutputStream)os).close();
    }

    private static class RemappingMethodVisitor
    extends MethodAdapter {
        private State state;
        private IntRef check = new IntRef();

        public RemappingMethodVisitor(MethodVisitor v, int access, Type[] args) {
            super(v);
            this.state = new State(access, args);
        }

        public RemappingMethodVisitor(RemappingMethodVisitor wrap) {
            super(wrap.mv);
            this.state = wrap.state;
        }

        protected int nextLocal(int size) {
            int var = this.state.nextLocal;
            this.state.nextLocal += size;
            return var;
        }

        private int remap(int var, int size) {
            if (var < this.state.firstLocal) {
                return var;
            }
            this.check.key = size == 2 ? ~var : var;
            Integer value = (Integer)this.state.locals.get(this.check);
            if (value == null) {
                IntRef ref = new IntRef();
                ref.key = this.check.key;
                value = new Integer(this.nextLocal(size));
                this.state.locals.put(ref, value);
            }
            return value;
        }

        public void visitIincInsn(int var, int increment) {
            this.mv.visitIincInsn(this.remap(var, 1), increment);
        }

        public void visitLocalVariable(String name, String desc, String sig, Label start, Label end, int index) {
            this.mv.visitLocalVariable(name, desc, sig, start, end, this.remap(index, 0));
        }

        public void visitVarInsn(int opcode, int var) {
            int size;
            switch (opcode) {
                case 22: 
                case 24: 
                case 55: 
                case 57: {
                    size = 2;
                    break;
                }
                default: {
                    size = 1;
                }
            }
            this.mv.visitVarInsn(opcode, this.remap(var, size));
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            this.mv.visitMaxs(0, 0);
        }
    }

    private static class IntRef {
        int key;

        private IntRef() {
        }

        public boolean equals(Object o) {
            return this.key == ((IntRef)o).key;
        }

        public int hashCode() {
            return this.key;
        }
    }

    private static class State {
        Map locals = new HashMap();
        int firstLocal;
        int nextLocal;

        State(int access, Type[] args) {
            this.nextLocal = (8 & access) != 0 ? 0 : 1;
            for (int i = 0; i < args.length; ++i) {
                this.nextLocal += args[i].getSize();
            }
            this.firstLocal = this.nextLocal;
        }
    }

    private static class PreProcessingVisitor
    extends RemappingMethodVisitor {
        public PreProcessingVisitor(MethodVisitor mv, int access, Type[] args) {
            super(mv, access, args);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if ((ClassLoaderPreProcessorImpl.DEFINECLASS0_METHOD_NAME.equals(name) || ClassLoaderPreProcessorImpl.DEFINECLASS1_METHOD_NAME.equals(name)) && ClassLoaderPreProcessorImpl.CLASSLOADER_CLASS_NAME.equals(owner)) {
                int i;
                Type[] args = Type.getArgumentTypes(desc);
                if (args.length < 5 || !desc.startsWith(ClassLoaderPreProcessorImpl.DESC_PREFIX)) {
                    throw new Error("non supported JDK, native call not supported: " + desc);
                }
                int[] locals = new int[args.length];
                for (i = args.length - 1; i >= 0; --i) {
                    locals[i] = this.nextLocal(args[i].getSize());
                    this.mv.visitVarInsn(args[i].getOpcode(54), locals[i]);
                }
                for (i = 0; i < 5; ++i) {
                    this.mv.visitVarInsn(args[i].getOpcode(21), locals[i]);
                }
                super.visitMethodInsn(184, "org/codehaus/aspectwerkz/hook/impl/ClassPreProcessorHelper", "defineClass0Pre", ClassLoaderPreProcessorImpl.DESC_HELPER);
                this.mv.visitVarInsn(58, locals[1]);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitVarInsn(25, locals[0]);
                this.mv.visitVarInsn(25, locals[1]);
                this.mv.visitInsn(3);
                this.mv.visitVarInsn(25, locals[1]);
                this.mv.visitInsn(190);
                this.mv.visitVarInsn(25, locals[4]);
                for (i = 5; i < args.length; ++i) {
                    this.mv.visitVarInsn(args[i].getOpcode(21), locals[i]);
                }
            } else if (ClassLoaderPreProcessorImpl.DEFINECLASS2_METHOD_NAME.equals(name) && ClassLoaderPreProcessorImpl.CLASSLOADER_CLASS_NAME.equals(owner)) {
                int i;
                Type[] args = Type.getArgumentTypes(desc);
                if (args.length < 5 || !desc.startsWith(ClassLoaderPreProcessorImpl.DESC_BYTEBUFFER_PREFIX)) {
                    throw new Error("non supported JDK, bytebuffer native call not supported: " + desc);
                }
                int[] locals = new int[args.length];
                for (i = args.length - 1; i >= 0; --i) {
                    locals[i] = this.nextLocal(args[i].getSize());
                    this.mv.visitVarInsn(args[i].getOpcode(54), locals[i]);
                }
                for (i = 0; i < 5; ++i) {
                    this.mv.visitVarInsn(args[i].getOpcode(21), locals[i]);
                }
                super.visitMethodInsn(184, "org/codehaus/aspectwerkz/hook/impl/ClassPreProcessorHelper", "defineClass0Pre", ClassLoaderPreProcessorImpl.DESC_BYTEBUFFER_HELPER);
                this.mv.visitVarInsn(58, locals[1]);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitVarInsn(25, locals[0]);
                this.mv.visitVarInsn(25, locals[1]);
                this.mv.visitInsn(3);
                this.mv.visitVarInsn(25, locals[1]);
                this.mv.visitMethodInsn(182, "Ljava/nio/Buffer;", "remaining", "()I");
                this.mv.visitVarInsn(25, locals[4]);
                for (i = 5; i < args.length; ++i) {
                    this.mv.visitVarInsn(args[i].getOpcode(21), locals[i]);
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class ClassLoaderVisitor
    extends ClassAdapter {
        public ClassLoaderVisitor(ClassVisitor cv) {
            super(cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor cv = super.visitMethod(access, name, desc, signature, exceptions);
            Type[] args = Type.getArgumentTypes(desc);
            return new PreProcessingVisitor(cv, access, args);
        }
    }
}

