/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.proxy;

import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.definition.SystemDefinitionContainer;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.hook.impl.ClassPreProcessorHelper;
import org.codehaus.aspectwerkz.proxy.Proxy;
import org.codehaus.aspectwerkz.proxy.ProxyDelegationCompiler;
import org.codehaus.aspectwerkz.proxy.Uuid;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.backport175.reader.bytecode.AnnotationReader;
import org.codehaus.backport175.reader.bytecode.spi.BytecodeProvider;

public class ProxyDelegationStrategy {
    private static final String PROXY_SUFFIX_START = "$$ProxiedByAWDelegation$$";
    private static final Map PROXY_CLASS_CACHE = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class getProxyClassFor(Class[] interfaces, boolean useCache, boolean makeAdvisable) {
        if (!useCache) {
            return ProxyDelegationStrategy.getNewProxyClassFor(interfaces, makeAdvisable);
        }
        CompositeClassKey key = new CompositeClassKey(interfaces);
        Map map = PROXY_CLASS_CACHE;
        synchronized (map) {
            Object cachedProxyClass = PROXY_CLASS_CACHE.get(key);
            if (cachedProxyClass != null) {
                return (Class)cachedProxyClass;
            }
            Class proxyClass = ProxyDelegationStrategy.getNewProxyClassFor(interfaces, makeAdvisable);
            PROXY_CLASS_CACHE.put(key, proxyClass);
            return proxyClass;
        }
    }

    static Object newInstance(Class[] interfaces, Object[] implementations, boolean useCache, boolean makeAdvisable) {
        if (!ProxyDelegationStrategy.implementsRespectively(interfaces, implementations)) {
            throw new RuntimeException("Given implementations not consistents with given interfaces");
        }
        Class proxy = ProxyDelegationStrategy.getProxyClassFor(interfaces, useCache, makeAdvisable);
        try {
            return proxy.getConstructor(interfaces).newInstance(implementations);
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException(t);
        }
    }

    private static boolean implementsRespectively(Class[] interfaces, Object[] implementations) {
        if (interfaces.length != implementations.length) {
            return false;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].isAssignableFrom(implementations[i].getClass())) continue;
            return false;
        }
        return true;
    }

    private static Class getNewProxyClassFor(Class[] interfaces, boolean makeAdvisable) {
        ClassLoader loader = ProxyDelegationStrategy.getLowestClassLoader(interfaces);
        String proxyClassName = ProxyDelegationStrategy.getUniqueClassNameForProxy(interfaces);
        if (makeAdvisable) {
            Proxy.makeProxyAdvisable(proxyClassName, loader);
        }
        final byte[] bytes = ProxyDelegationCompiler.compileProxyFor(loader, interfaces, proxyClassName);
        AnnotationReader.setBytecodeProviderFor(proxyClassName, loader, new BytecodeProvider(){

            public byte[] getBytecode(String className, ClassLoader loader) throws Exception {
                return bytes;
            }
        });
        byte[] transformedBytes = ClassPreProcessorHelper.defineClass0Pre(loader, proxyClassName, bytes, 0, bytes.length, null);
        return AsmHelper.defineClass(loader, transformedBytes, proxyClassName);
    }

    private static ClassLoader getLowestClassLoader(Class[] classes) {
        ClassLoader loader = classes[0].getClassLoader();
        for (int i = 1; i < classes.length; ++i) {
            Class other = classes[i];
            if (SystemDefinitionContainer.isChildOf(other.getClassLoader(), loader)) {
                loader = other.getClassLoader();
                continue;
            }
            if (SystemDefinitionContainer.isChildOf(loader, other.getClassLoader())) continue;
            throw new RuntimeException("parallel classloader hierarchy not supported");
        }
        return loader;
    }

    private static String getUniqueClassNameForProxy(Class[] interfaces) {
        return interfaces[0].getName().replace('.', '/') + PROXY_SUFFIX_START + new Long(Uuid.newUuid()).toString();
    }

    private static class CompositeClassKey {
        private final Class[] m_interfaces;

        CompositeClassKey(Class[] interfaces) {
            this.m_interfaces = interfaces;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CompositeClassKey)) {
                return false;
            }
            CompositeClassKey compositeClassKey = (CompositeClassKey)o;
            return Arrays.equals(this.m_interfaces, compositeClassKey.m_interfaces);
        }

        public int hashCode() {
            int result = 1;
            for (int i = 0; i < this.m_interfaces.length; ++i) {
                result = 31 * result + this.m_interfaces[i].hashCode();
            }
            return result;
        }
    }
}

