/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.org.objectweb.asm.AnnotationVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Attribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassReader;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.AsmCopyAdapter;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.AsmNullAdapter;

public class ProxySubclassingCompiler
implements TransformationConstants {
    public static byte[] compileProxyFor(Class clazz, String proxyClassName) {
        return ProxySubclassingCompiler.compileProxyFor(clazz.getClassLoader(), clazz.getName(), proxyClassName);
    }

    public static byte[] compileProxyFor(ClassLoader loader, String className, String proxyClassName) {
        ClassReader classReader;
        String targetClassName = className.replace('.', '/');
        ClassWriter proxyWriter = AsmHelper.newClassWriter(true);
        InputStream in = null;
        try {
            in = loader != null ? loader.getResourceAsStream(targetClassName + ".class") : ClassLoader.getSystemClassLoader().getResourceAsStream(targetClassName + ".class");
            classReader = new ClassReader(in);
        }
        catch (IOException e) {
            throw new WrappedRuntimeException("Cannot compile proxy for " + className, e);
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable t) {}
        }
        ProxyCompilerClassVisitor createProxy = new ProxyCompilerClassVisitor(proxyWriter, proxyClassName.replace('.', '/'));
        classReader.accept(createProxy, true);
        return proxyWriter.toByteArray();
    }

    private static class ProxyCompilerClassVisitor
    extends AsmNullAdapter.NullClassAdapter {
        private final ClassVisitor m_proxyCv;
        private final String m_proxyClassName;
        private String m_className;

        public ProxyCompilerClassVisitor(ClassVisitor proxyCv, String proxyClassName) {
            this.m_proxyCv = proxyCv;
            this.m_proxyClassName = proxyClassName;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (Modifier.isFinal(access)) {
                throw new RuntimeException("Cannot create a proxy from final class " + name);
            }
            this.m_className = name;
            this.m_proxyCv.visit(version, 4129, this.m_proxyClassName.replace('.', '/'), signature, name, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            boolean copyAnnotation;
            MethodVisitor proxyCode;
            if (Modifier.isFinal(access) || Modifier.isPrivate(access) || Modifier.isNative(access)) {
                proxyCode = AsmNullAdapter.NullMethodAdapter.NULL_METHOD_ADAPTER;
                copyAnnotation = false;
            } else if ("<clinit>".equals(name)) {
                proxyCode = AsmNullAdapter.NullMethodAdapter.NULL_METHOD_ADAPTER;
                copyAnnotation = false;
            } else if ("<init>".equals(name)) {
                proxyCode = this.m_proxyCv.visitMethod(access + 4096, "<init>", desc, signature, exceptions);
                proxyCode.visitVarInsn(25, 0);
                AsmHelper.loadArgumentTypes(proxyCode, Type.getArgumentTypes(desc), false);
                proxyCode.visitMethodInsn(183, this.m_className, "<init>", desc);
                proxyCode.visitInsn(177);
                proxyCode.visitMaxs(0, 0);
                copyAnnotation = true;
            } else {
                proxyCode = this.m_proxyCv.visitMethod(access + 4096, name, desc, signature, exceptions);
                if (Modifier.isStatic(access)) {
                    AsmHelper.loadArgumentTypes(proxyCode, Type.getArgumentTypes(desc), true);
                    proxyCode.visitMethodInsn(184, this.m_className, name, desc);
                    AsmHelper.addReturnStatement(proxyCode, Type.getReturnType(desc));
                    proxyCode.visitMaxs(0, 0);
                } else {
                    proxyCode.visitVarInsn(25, 0);
                    AsmHelper.loadArgumentTypes(proxyCode, Type.getArgumentTypes(desc), false);
                    proxyCode.visitMethodInsn(183, this.m_className, name, desc);
                    AsmHelper.addReturnStatement(proxyCode, Type.getReturnType(desc));
                    proxyCode.visitMaxs(0, 0);
                }
                copyAnnotation = true;
            }
            if (copyAnnotation) {
                return new AsmCopyAdapter.CopyMethodAnnotationElseNullAdapter(proxyCode);
            }
            return AsmNullAdapter.NullMethodAdapter.NULL_METHOD_ADAPTER;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AsmCopyAdapter.CopyAnnotationAdapter(super.visitAnnotation(desc, visible), this.m_proxyCv.visitAnnotation(desc, visible));
        }

        public void visitAttribute(Attribute attribute) {
            this.m_proxyCv.visitAttribute(attribute);
        }
    }
}

