/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.transform.inlining.compiler.AspectWerkzAspectModel;
import org.codehaus.aspectwerkz.transform.inlining.spi.AspectModel;
import org.codehaus.aspectwerkz.util.ContextClassLoader;

public class AspectModelManager {
    public static final String ASPECT_MODELS_VM_OPTION = "aspectwerkz.extension.aspectmodels";
    private static final String DELIMITER = ":";
    private static List ASPECT_MODELS = new ArrayList(1);

    public static AspectModel[] getModels() {
        return ASPECT_MODELS.toArray(new AspectModel[0]);
    }

    public static AspectModel getModelFor(String type) {
        for (AspectModel aspectModel : ASPECT_MODELS) {
            if (!aspectModel.getAspectModelType().equals(type)) continue;
            return aspectModel;
        }
        return null;
    }

    public static void defineAspect(ClassInfo aspectClassInfo, AspectDefinition aspectDef, ClassLoader loader) {
        for (AspectModel aspectModel : ASPECT_MODELS) {
            aspectModel.defineAspect(aspectClassInfo, aspectDef, loader);
        }
    }

    public static void registerAspectModels(String aspectModels) {
        if (aspectModels != null) {
            StringTokenizer tokenizer = new StringTokenizer(aspectModels, DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                String className = tokenizer.nextToken();
                try {
                    Class modelClass = ContextClassLoader.forName(className);
                    ASPECT_MODELS.add((AspectModel)modelClass.newInstance());
                }
                catch (ClassNotFoundException e) {
                    throw new DefinitionException("aspect model implementation class not found [" + className + "]: " + e.toString());
                }
                catch (Exception e) {
                    throw new DefinitionException("aspect model implementation class could not be instantiated [" + className + "] - make sure it has a default no argument constructor: " + e.toString());
                }
            }
        }
    }

    static {
        ASPECT_MODELS.add(new AspectWerkzAspectModel());
        AspectModelManager.registerAspectModels(System.getProperty(ASPECT_MODELS_VM_OPTION, null));
    }
}

