/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.deployer;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinitionContainer;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.util.UuidGenerator;

public final class DeploymentHandle {
    private final String UUID;
    private final Map m_definitionChangeElements = new HashMap();
    private final WeakReference m_loaderRef;
    private final WeakReference m_classRef;

    DeploymentHandle(Class clazz, ClassLoader loader) {
        if (clazz == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        if (loader == null) {
            throw new IllegalArgumentException("loader can not be null");
        }
        this.UUID = UuidGenerator.generate(clazz);
        this.m_loaderRef = new WeakReference<ClassLoader>(loader);
        this.m_classRef = new WeakReference<Class>(clazz);
    }

    void registerDefinitionChange(AdviceDefinition adviceDef, ExpressionInfo oldExpression) {
        this.m_definitionChangeElements.put(adviceDef.getQualifiedName(), new DefinitionChangeElement(adviceDef, oldExpression));
    }

    Class getAspectClass() {
        return (Class)this.m_classRef.get();
    }

    Map getDefintionChangeElements() {
        return this.m_definitionChangeElements;
    }

    void revertChanges() {
        ClassLoader loader = (ClassLoader)this.m_loaderRef.get();
        SystemDefinition systemDef = SystemDefinitionContainer.getVirtualDefinitionAt(loader);
        for (AspectDefinition aspectDef : systemDef.getAspectDefinitions()) {
            for (AdviceDefinition adviceDef : aspectDef.getAfterAdviceDefinitions()) {
                DefinitionChangeElement changeElement = (DefinitionChangeElement)this.m_definitionChangeElements.get(adviceDef.getQualifiedName());
                if (changeElement == null) continue;
                changeElement.getAdviceDef().setExpressionInfo(changeElement.getOldExpression());
            }
        }
    }

    public String toString() {
        return new StringBuffer().append("DeploymentHandle [").append(this.UUID.toString()).append(',').append(((Class)this.m_classRef.get()).getName()).append(',').append((ClassLoader)this.m_loaderRef.get()).append(']').toString();
    }

    public int hashCode() {
        return this.UUID.hashCode();
    }

    public boolean equals(Object o) {
        return ((DeploymentHandle)o).UUID.equals(this.UUID);
    }

    static class DefinitionChangeElement {
        private final AdviceDefinition m_adviceDef;
        private final ExpressionInfo m_oldExpression;

        public DefinitionChangeElement(AdviceDefinition adviceDef, ExpressionInfo oldExpression) {
            this.m_adviceDef = adviceDef;
            this.m_oldExpression = oldExpression;
        }

        public ExpressionInfo getOldExpression() {
            return this.m_oldExpression;
        }

        public AdviceDefinition getAdviceDef() {
            return this.m_adviceDef;
        }
    }
}

