/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.reflect.MemberInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.TransformationUtil;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.transform.inlining.weaver.AfterObjectInitializationCodeAdapter;

public class MethodCallVisitor
extends ClassAdapter
implements TransformationConstants {
    private final ContextImpl m_ctx;
    private final ClassLoader m_loader;
    private final ClassInfo m_callerClassInfo;
    private Label m_lastLabelForLineNumber = EmittedJoinPoint.NO_LINE_NUMBER;

    public MethodCallVisitor(ClassVisitor cv, ClassLoader loader, ClassInfo classInfo, Context ctx) {
        super(cv);
        this.m_loader = loader;
        this.m_callerClassInfo = classInfo;
        this.m_ctx = (ContextImpl)ctx;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.startsWith("aw$") || Modifier.isNative(access) || Modifier.isAbstract(access)) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        return mv == null ? null : new ReplaceInvokeInstructionCodeAdapter(mv, this.m_loader, this.m_callerClassInfo, this.m_ctx.getClassName(), name, desc);
    }

    public class ReplaceInvokeInstructionCodeAdapter
    extends AfterObjectInitializationCodeAdapter {
        private final ClassLoader m_loader;
        private final ClassInfo m_callerClassInfo;
        private final String m_callerClassName;
        private final String m_callerMethodName;
        private final String m_callerMethodDesc;
        private final MemberInfo m_callerMemberInfo;

        public ReplaceInvokeInstructionCodeAdapter(MethodVisitor ca, ClassLoader loader, ClassInfo callerClassInfo, String callerClassName, String callerMethodName, String callerMethodDesc) {
            super(ca, callerMethodName);
            this.m_loader = loader;
            this.m_callerClassInfo = callerClassInfo;
            this.m_callerClassName = callerClassName;
            this.m_callerMethodName = callerMethodName;
            this.m_callerMethodDesc = callerMethodDesc;
            if ("<clinit>".equals(callerMethodName)) {
                this.m_callerMemberInfo = this.m_callerClassInfo.staticInitializer();
            } else if ("<init>".equals(callerMethodName)) {
                int hash = AsmHelper.calculateConstructorHash(this.m_callerMethodDesc);
                this.m_callerMemberInfo = this.m_callerClassInfo.getConstructor(hash);
            } else {
                int hash = AsmHelper.calculateMethodHash(this.m_callerMethodName, this.m_callerMethodDesc);
                this.m_callerMemberInfo = this.m_callerClassInfo.getMethod(hash);
            }
        }

        public void visitLabel(Label label) {
            MethodCallVisitor.this.m_lastLabelForLineNumber = label;
            super.visitLabel(label);
        }

        public void visitMethodInsn(int opcode, String calleeClassName, String calleeMethodName, String calleeMethodDesc) {
            if (this.m_callerMemberInfo == null) {
                System.err.println("AW::WARNING metadata structure could not be build for method [" + this.m_callerClassInfo.getName().replace('/', '.') + '.' + this.m_callerMethodName + ':' + this.m_callerMethodDesc + ']');
                super.visitMethodInsn(opcode, calleeClassName, calleeMethodName, calleeMethodDesc);
                return;
            }
            if ("<init>".equals(calleeMethodName) || "<clinit>".equals(calleeMethodName) || calleeMethodName.startsWith("___AW_") || calleeClassName.endsWith("___AW_JoinPoint")) {
                super.visitMethodInsn(opcode, calleeClassName, calleeMethodName, calleeMethodDesc);
                return;
            }
            if (opcode == 183 && !calleeClassName.equals(this.m_callerClassName) && ClassInfoHelper.extendsSuperClass(this.m_callerClassInfo, calleeClassName.replace('/', '.'))) {
                super.visitMethodInsn(opcode, calleeClassName, calleeMethodName, calleeMethodDesc);
                return;
            }
            if (!this.m_isObjectInitialized) {
                super.visitMethodInsn(opcode, calleeClassName, calleeMethodName, calleeMethodDesc);
                return;
            }
            int joinPointHash = AsmHelper.calculateMethodHash(calleeMethodName, calleeMethodDesc);
            ClassInfo classInfo = AsmClassInfo.getClassInfo(calleeClassName, this.m_loader);
            MethodInfo calleeMethodInfo = classInfo.getMethod(joinPointHash);
            if (calleeMethodInfo == null) {
                System.err.println("AW::WARNING metadata structure could not be build for method [" + classInfo.getName().replace('/', '.') + '.' + calleeMethodName + ':' + calleeMethodDesc + "] when parsing method [" + this.m_callerClassInfo.getName() + '.' + this.m_callerMethodName + "(..)]");
                super.visitMethodInsn(opcode, calleeClassName, calleeMethodName, calleeMethodDesc);
                return;
            }
            ExpressionContext ctx = new ExpressionContext(PointcutType.CALL, calleeMethodInfo, this.m_callerMemberInfo);
            if (this.methodFilter(MethodCallVisitor.this.m_ctx.getDefinitions(), ctx, calleeMethodInfo)) {
                super.visitMethodInsn(opcode, calleeClassName, calleeMethodName, calleeMethodDesc);
            } else {
                MethodCallVisitor.this.m_ctx.markAsAdvised();
                String joinPointClassName = TransformationUtil.getJoinPointClassName(this.m_callerClassName, this.m_callerMethodName, this.m_callerMethodDesc, calleeClassName, 2, joinPointHash);
                if (Modifier.isStatic(this.m_callerMemberInfo.getModifiers())) {
                    this.visitInsn(1);
                } else {
                    this.visitVarInsn(25, 0);
                }
                super.visitMethodInsn(184, joinPointClassName, "invoke", TransformationUtil.getInvokeSignatureForCodeJoinPoints(calleeMethodInfo.getModifiers(), calleeMethodDesc, this.m_callerClassName, calleeClassName));
                int modifiers = calleeMethodInfo.getModifiers();
                if (opcode == 185) {
                    modifiers |= 0x10000000;
                }
                MethodCallVisitor.this.m_ctx.addEmittedJoinPoint(new EmittedJoinPoint(2, this.m_callerClassName, this.m_callerMethodName, this.m_callerMethodDesc, this.m_callerMemberInfo.getModifiers(), calleeClassName, calleeMethodName, calleeMethodDesc, modifiers, joinPointHash, joinPointClassName, MethodCallVisitor.this.m_lastLabelForLineNumber));
            }
        }

        public boolean methodFilter(Set definitions, ExpressionContext ctx, MethodInfo calleeMethodInfo) {
            if (calleeMethodInfo.getName().equals("<init>") || calleeMethodInfo.getName().equals("<clinit>") || calleeMethodInfo.getName().startsWith("aw$original$_AW_$")) {
                return true;
            }
            Iterator it = definitions.iterator();
            while (it.hasNext()) {
                if (!((SystemDefinition)it.next()).hasPointcut(ctx)) continue;
                return false;
            }
            return true;
        }
    }
}

