/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.dispatch.SaneRejectedExecutionHandler;
import akka.dispatch.ThreadPoolConfig;
import akka.util.Duration;
import akka.util.Duration$;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import scala.Either;
import scala.Function0;
import scala.Left;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Right;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple7;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadPoolConfig$
implements ScalaObject,
Serializable {
    public static final ThreadPoolConfig$ MODULE$;
    private final boolean defaultAllowCoreThreadTimeout;
    private final boolean defaultDaemonic;
    private final int defaultCorePoolSize;
    private final int defaultMaxPoolSize;
    private final Duration defaultTimeout;

    static {
        new ThreadPoolConfig$();
    }

    public boolean defaultAllowCoreThreadTimeout() {
        return this.defaultAllowCoreThreadTimeout;
    }

    public boolean defaultDaemonic() {
        return this.defaultDaemonic;
    }

    public int defaultCorePoolSize() {
        return this.defaultCorePoolSize;
    }

    public int defaultMaxPoolSize() {
        return this.defaultMaxPoolSize;
    }

    public Duration defaultTimeout() {
        return this.defaultTimeout;
    }

    public Either<RejectedExecutionHandler, Object> defaultFlowHandler() {
        return this.flowHandler(new SaneRejectedExecutionHandler());
    }

    public Either<RejectedExecutionHandler, Object> flowHandler(RejectedExecutionHandler rejectionHandler) {
        return new Left((Object)rejectionHandler);
    }

    public Either<RejectedExecutionHandler, Object> flowHandler(int bounds) {
        return new Right((Object)BoxesRunTime.boxToInteger((int)bounds));
    }

    public int fixedPoolSize(int size) {
        return size;
    }

    public int scaledPoolSize(double multiplier) {
        return (int)Predef$.MODULE$.doubleWrapper((double)Runtime.getRuntime().availableProcessors() * multiplier).ceil();
    }

    public Function0<BlockingQueue<Runnable>> arrayBlockingQueue(int capacity$1, boolean fair$1) {
        return new Serializable(capacity$1, fair$1){
            public static final long serialVersionUID;
            public final int capacity$1;
            public final boolean fair$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ArrayBlockingQueue<Runnable> apply() {
                return new ArrayBlockingQueue<Runnable>(this.capacity$1, this.fair$1);
            }
            {
                this.capacity$1 = n;
                this.fair$1 = bl;
            }
        };
    }

    public Function0<BlockingQueue<Runnable>> synchronousQueue(boolean fair$2) {
        return new Serializable(fair$2){
            public static final long serialVersionUID;
            public final boolean fair$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final SynchronousQueue<Runnable> apply() {
                return new SynchronousQueue<Runnable>(this.fair$2);
            }
            {
                this.fair$2 = bl;
            }
        };
    }

    public Function0<BlockingQueue<Runnable>> linkedBlockingQueue() {
        return new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LinkedBlockingQueue<Runnable> apply() {
                return new LinkedBlockingQueue<Runnable>();
            }
        };
    }

    public Function0<BlockingQueue<Runnable>> linkedBlockingQueue(int capacity$2) {
        return new Serializable(capacity$2){
            public static final long serialVersionUID;
            public final int capacity$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LinkedBlockingQueue<Runnable> apply() {
                return new LinkedBlockingQueue<Runnable>(this.capacity$2);
            }
            {
                this.capacity$2 = n;
            }
        };
    }

    public Function0<BlockingQueue<Runnable>> reusableQueue(BlockingQueue<Runnable> queue$1) {
        return new Serializable(queue$1){
            public static final long serialVersionUID;
            public final BlockingQueue queue$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final BlockingQueue<Runnable> apply() {
                return this.queue$1;
            }
            {
                this.queue$1 = blockingQueue;
            }
        };
    }

    public Function0<BlockingQueue<Runnable>> reusableQueue(Function0<BlockingQueue<Runnable>> queueFactory) {
        BlockingQueue queue$2 = (BlockingQueue)queueFactory.apply();
        return new Serializable(queue$2){
            public static final long serialVersionUID;
            public final BlockingQueue queue$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final BlockingQueue<Runnable> apply() {
                return this.queue$2;
            }
            {
                this.queue$2 = blockingQueue;
            }
        };
    }

    public boolean init$default$7() {
        return this.defaultDaemonic();
    }

    public Function0 init$default$6() {
        return this.linkedBlockingQueue();
    }

    public Either init$default$5() {
        return this.defaultFlowHandler();
    }

    public Duration init$default$4() {
        return this.defaultTimeout();
    }

    public int init$default$3() {
        return this.defaultMaxPoolSize();
    }

    public int init$default$2() {
        return this.defaultCorePoolSize();
    }

    public boolean init$default$1() {
        return this.defaultAllowCoreThreadTimeout();
    }

    public boolean apply$default$7() {
        return this.defaultDaemonic();
    }

    public Function0 apply$default$6() {
        return this.linkedBlockingQueue();
    }

    public Either apply$default$5() {
        return this.defaultFlowHandler();
    }

    public Duration apply$default$4() {
        return this.defaultTimeout();
    }

    public int apply$default$3() {
        return this.defaultMaxPoolSize();
    }

    public int apply$default$2() {
        return this.defaultCorePoolSize();
    }

    public boolean apply$default$1() {
        return this.defaultAllowCoreThreadTimeout();
    }

    public Option unapply(ThreadPoolConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)BoxesRunTime.boxToBoolean((boolean)x$0.allowCorePoolTimeout()), (Object)BoxesRunTime.boxToInteger((int)x$0.corePoolSize()), (Object)BoxesRunTime.boxToInteger((int)x$0.maxPoolSize()), (Object)x$0.threadTimeout(), x$0.flowHandler(), x$0.queueFactory(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.daemonic())));
    }

    public ThreadPoolConfig apply(boolean allowCorePoolTimeout, int corePoolSize, int maxPoolSize, Duration threadTimeout, Either flowHandler, Function0 queueFactory, boolean daemonic) {
        return new ThreadPoolConfig(allowCorePoolTimeout, corePoolSize, maxPoolSize, threadTimeout, (Either<RejectedExecutionHandler, Object>)flowHandler, (Function0<BlockingQueue<Runnable>>)queueFactory, daemonic);
    }

    public Object readResolve() {
        return MODULE$;
    }

    private ThreadPoolConfig$() {
        MODULE$ = this;
        this.defaultAllowCoreThreadTimeout = false;
        this.defaultDaemonic = false;
        this.defaultCorePoolSize = 16;
        this.defaultMaxPoolSize = 128;
        this.defaultTimeout = Duration$.MODULE$.apply(60000L, TimeUnit.MILLISECONDS);
    }
}

