/*
 * Decompiled with CFR 0.152.
 */
package play.modules.carbonate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Entity;
import org.apache.commons.lang.StringUtils;
import org.hibernate.dialect.Dialect;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import play.Logger;
import play.Play;
import play.db.DB;
import play.db.DBPlugin;
import play.modules.carbonate.MigrationUtils;
import play.utils.Utils;

public class NewMigrationMain {
    private static final SimpleDateFormat versionFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    public static void main(String[] args) throws IOException, SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Please write description for you migration:");
        String description = reader.readLine();
        String id = System.getProperty("play.id", "");
        Play.init((File)new File("."), (String)id);
        Ejb3Configuration configuration = new Ejb3Configuration();
        String driver = Play.configuration.getProperty("db.driver");
        String migrationBody = "";
        if (driver != null) {
            String dialectName = MigrationUtils.getDefaultDialect(driver);
            configuration.setProperty("hibernate.dialect", dialectName);
            Properties fromConf = (Properties)Utils.Maps.filterMap((Map)Play.configuration, (String)"^hibernate\\..*");
            configuration.addProperties(fromConf);
            List classes = Play.classloader.getAnnotatedClasses(Entity.class);
            Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
            if (classes.isEmpty()) {
                Logger.warn((String)"No entities detected!", (Object[])new Object[0]);
            }
            for (Class clazz : classes) {
                configuration.addAnnotatedClass(clazz);
            }
            configuration.buildEntityManagerFactory();
            DBPlugin plugin = new DBPlugin();
            plugin.onApplicationStart();
            Dialect dialect = (Dialect)Class.forName(dialectName).newInstance();
            DatabaseMetadata metadata = new DatabaseMetadata(DB.getConnection(), dialect);
            Object[] content = configuration.getHibernateConfiguration().generateSchemaUpdateScript(dialect, metadata);
            if (content.length == 0) {
                Logger.warn((String)"No changes from schema update!", (Object[])new Object[0]);
            }
            migrationBody = StringUtils.join((Object[])content, (String)"\n");
        } else {
            Logger.warn((String)"Property 'db.driver' not defined in Play configuration, ignoring schema update!", (Object[])new Object[0]);
        }
        String path = MigrationUtils.getPath();
        File directory = new File(path);
        if (!directory.exists()) {
            Logger.warn((String)("Creating non-existent directory " + directory.getAbsolutePath()), (Object[])new Object[0]);
            directory.mkdirs();
        }
        String version = versionFormat.format(new Date());
        description = StringUtils.replaceChars((String)description, (char)' ', (char)'_');
        description = StringUtils.replaceChars((String)description, (String)".,:;", (String)"");
        description = description.toLowerCase();
        File migrationFile = new File(directory, version + "_" + description + ".sql");
        migrationFile.createNewFile();
        PrintWriter writer = new PrintWriter(new FileWriter(migrationFile));
        writer.println("-- You can write you comments here ");
        writer.println(migrationBody);
        writer.close();
        Logger.warn((String)("New migration file created " + migrationFile.getAbsolutePath()), (Object[])new Object[0]);
    }
}

