/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration;

import com.carbonfive.db.migration.Migration;
import com.carbonfive.db.migration.MigrationException;
import com.carbonfive.db.migration.MigrationFactory;
import com.carbonfive.db.migration.MigrationResolver;
import com.carbonfive.db.migration.Resource;
import com.carbonfive.db.migration.SimpleVersionExtractor;
import com.carbonfive.db.migration.VersionExtractor;
import com.carbonfive.jdbc.DatabaseType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.Play;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMigrationResolver
implements MigrationResolver {
    private static final String PATH_MIGRATIONS_SQL = "conf/migrations";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String migrationsLocation;
    private VersionExtractor versionExtractor;
    private MigrationFactory migrationFactory = new MigrationFactory();

    public ResourceMigrationResolver() {
        this(PATH_MIGRATIONS_SQL);
    }

    public ResourceMigrationResolver(String migrationsLocation) {
        this(migrationsLocation, new SimpleVersionExtractor());
    }

    public ResourceMigrationResolver(String migrationsLocation, VersionExtractor versionExtractor) {
        this.setMigrationsLocation(migrationsLocation);
        this.setVersionExtractor(versionExtractor);
    }

    @Override
    public Set<Migration> resolve(DatabaseType dbType) {
        HashSet<Migration> migrations = new HashSet<Migration>();
        File path = new File(Play.applicationPath, this.migrationsLocation);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Collection files = FileUtils.listFiles((File)path, (String[])new String[]{"sql"}, (boolean)true);
        for (File file : files) {
            resources.add(new Resource(file));
        }
        if (resources.isEmpty()) {
            String message = "No migrations were found from path '" + path.getAbsolutePath() + "'.";
            this.logger.error(message);
            throw new MigrationException(message);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Found " + resources.size() + " resources: " + resources);
        }
        for (Resource resource : resources) {
            String version = this.versionExtractor.extractVersion(resource.getFilename());
            if (CollectionUtils.find(migrations, (Predicate)new Migration.MigrationVersionPredicate(version)) != null) {
                String message = "Non-unique migration version.";
                this.logger.error(message);
                throw new MigrationException(message);
            }
            migrations.add(this.migrationFactory.create(version, resource));
        }
        return migrations;
    }

    @Override
    public Set<Migration> resolve() {
        return this.resolve(DatabaseType.UNKNOWN);
    }

    public void setMigrationsLocation(String migrationsLocation) {
        this.migrationsLocation = migrationsLocation;
    }

    public void setVersionExtractor(VersionExtractor versionExtractor) {
        this.versionExtractor = versionExtractor;
    }

    public void setMigrationFactory(MigrationFactory migrationFactory) {
        this.migrationFactory = migrationFactory;
    }
}

