/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration;

import com.carbonfive.db.migration.DefaultedMap;
import com.carbonfive.db.migration.MigrationException;
import com.carbonfive.db.migration.VersionStrategy;
import com.carbonfive.jdbc.DatabaseType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleVersionStrategy
implements VersionStrategy {
    public static final String DEFAULT_VERSION_TABLE = "schema_version";
    public static final String DEFAULT_VERSION_COLUMN = "version";
    public static final String DEFAULT_APPLIED_DATE_COLUMN = "applied_on";
    public static final String DEFAULT_DURATION_COLUMN = "duration";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String versionTable = "schema_version";
    private String versionColumn = "version";
    private String appliedDateColumn = "applied_on";
    private String durationColumn = "duration";
    private static final DefaultedMap enableVersioningDDL = new DefaultedMap("create table %s (%s varchar(32) not null unique, %s timestamp not null, %s int not null)");

    @Override
    public boolean isEnabled(DatabaseType dbType, Connection connection) {
        try {
            connection.createStatement().executeQuery("select count(*) from " + this.versionTable);
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    @Override
    public void enableVersioning(DatabaseType dbType, Connection connection) {
        try {
            String ddl = String.format((String)enableVersioningDDL.get((Object)dbType), this.versionTable, this.versionColumn, this.appliedDateColumn, this.durationColumn);
            connection.createStatement().executeUpdate(ddl);
        }
        catch (SQLException e) {
            throw new MigrationException("Could not create version-tracking table '" + this.versionTable + "'.", e);
        }
    }

    @Override
    public Set<String> appliedMigrations(DatabaseType dbType, Connection connection) {
        if (!this.isEnabled(dbType, connection)) {
            return null;
        }
        HashSet<String> migrations = new HashSet<String>();
        try {
            ResultSet rs = connection.createStatement().executeQuery("select " + this.versionColumn + " from " + this.versionTable);
            while (rs.next()) {
                migrations.add(rs.getString(this.versionColumn));
            }
        }
        catch (SQLException e) {
            throw new MigrationException(e);
        }
        return migrations;
    }

    @Override
    public void recordMigration(DatabaseType dbType, Connection connection, String version, Date startTime, long duration) {
        try {
            PreparedStatement statement = connection.prepareStatement("insert into " + this.versionTable + " values (?, ?, ?)");
            statement.setString(1, version);
            statement.setTimestamp(2, new Timestamp(startTime.getTime()));
            statement.setLong(3, duration);
            statement.execute();
        }
        catch (SQLException e) {
            throw new MigrationException(e);
        }
    }

    public void setVersionTable(String versionTable) {
        this.versionTable = versionTable;
    }

    public void setVersionColumn(String versionColumn) {
        this.versionColumn = versionColumn;
    }

    public void setAppliedDateColumn(String appliedDateColumn) {
        this.appliedDateColumn = appliedDateColumn;
    }

    public void setDurationColumn(String durationColumn) {
        this.durationColumn = durationColumn;
    }

    static {
        enableVersioningDDL.put(DatabaseType.HSQL, "create table %s (%s varchar not null, %s datetime not null, %s int not null, constraint %2$s_unique unique (%2$s))");
        enableVersioningDDL.put(DatabaseType.SQL_SERVER, "create table %s (%s varchar(32) not null unique, %s datetime not null, %s int not null)");
    }
}

