/*
 * Decompiled with CFR 0.152.
 */
package play.modules.carbonate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Entity;
import org.apache.commons.lang.StringUtils;
import org.hibernate.dialect.Dialect;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import play.Logger;
import play.Play;
import play.db.DB;
import play.db.DBPlugin;
import play.modules.carbonate.MigrationUtils;
import play.utils.Utils;

public class NewMigrationMain {
    private static final SimpleDateFormat versionFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    public static void main(String[] args) throws IOException, SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Please give description for you migration:");
        String description = reader.readLine();
        String appPath = System.getProperty("application.path", ".");
        String id = System.getProperty("play.id", "");
        Play.init((File)new File(appPath), (String)id);
        String path = MigrationUtils.getPath();
        if (path == null) {
            Logger.warn((String)"Missing required configuration 'carbonate.path', quitting!", (Object[])new Object[0]);
            return;
        }
        Ejb3Configuration configuration = new Ejb3Configuration();
        String driver = Play.configuration.getProperty("db.driver");
        String delimeter = Play.configuration.getProperty("carbonate.delimeter", ";");
        String comment = Play.configuration.getProperty("carbonate.comment", "--");
        String migrationBody = "";
        if (driver != null) {
            String dialectName = MigrationUtils.getDefaultDialect(driver);
            configuration.setProperty("hibernate.dialect", dialectName);
            Properties fromConf = (Properties)Utils.Maps.filterMap((Map)Play.configuration, (String)"^hibernate\\..*");
            configuration.addProperties(fromConf);
            List classes = Play.classloader.getAnnotatedClasses(Entity.class);
            Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
            if (classes.isEmpty()) {
                Logger.warn((String)"No entities detected!", (Object[])new Object[0]);
            }
            for (Class clazz : classes) {
                configuration.addAnnotatedClass(clazz);
            }
            configuration.buildEntityManagerFactory();
            DBPlugin plugin = new DBPlugin();
            plugin.onApplicationStart();
            Dialect dialect = (Dialect)Class.forName(dialectName).newInstance();
            DatabaseMetadata metadata = new DatabaseMetadata(DB.getConnection(), dialect);
            Object[] content = configuration.getHibernateConfiguration().generateSchemaUpdateScript(dialect, metadata);
            if (content.length == 0) {
                Logger.warn((String)"No changes from schema update!", (Object[])new Object[0]);
            } else {
                migrationBody = StringUtils.join((Object[])content, (String)(delimeter + "\n"));
                migrationBody = migrationBody + delimeter;
                Logger.warn((String)("Changes from schema update:\n" + migrationBody), (Object[])new Object[0]);
            }
        } else {
            Logger.warn((String)"Property 'db.driver' not defined in Play configuration, ignoring schema update!", (Object[])new Object[0]);
        }
        File directory = new File(path);
        if (!directory.exists()) {
            Logger.warn((String)("Creating non-existent directory " + directory.getAbsolutePath()), (Object[])new Object[0]);
            directory.mkdirs();
        }
        Date now = new Date();
        String version = versionFormat.format(now);
        String filename = StringUtils.replaceChars((String)description, (char)' ', (char)'_');
        filename = StringUtils.replaceChars((String)filename, (String)".,:;", (String)"");
        filename = filename.toLowerCase();
        File migrationFile = new File(directory, version + "_" + filename + ".sql");
        migrationFile.createNewFile();
        PrintWriter writer = new PrintWriter(new FileWriter(migrationFile));
        writer.println(comment + " " + String.format("%1$tF %<tT", now) + " - Database migration generated by play-carbonate (https://github.com/huljas/play-carbonate)");
        writer.println(comment + " " + description);
        writer.println(migrationBody);
        writer.close();
        Logger.warn((String)("New migration file created " + migrationFile.getAbsolutePath()), (Object[])new Object[0]);
    }
}

