/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration;

import com.carbonfive.db.migration.AbstractMigration;
import com.carbonfive.db.migration.MigrationException;
import com.carbonfive.db.migration.Resource;
import com.carbonfive.jdbc.DatabaseType;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class GroovyMigration
extends AbstractMigration {
    private final Resource script;

    public GroovyMigration(String version, Resource script) {
        super(version, script.getFilename());
        this.script = script;
    }

    public void migrate(DatabaseType dbType, Connection connection) {
        Binding binding = new Binding();
        binding.setVariable("connection", (Object)connection);
        GroovyShell shell = new GroovyShell(binding);
        InputStream inputStream = null;
        try {
            inputStream = this.script.getInputStream();
            shell.evaluate(IOUtils.toString((InputStream)inputStream));
            Validate.isTrue((!connection.isClosed() ? 1 : 0) != 0, (String)"JDBC Connection should not be closed.");
        }
        catch (IOException e) {
            throw new MigrationException(e);
        }
        catch (SQLException e) {
            throw new MigrationException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

