/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.jdbc;

import com.carbonfive.jdbc.DatabaseType;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRunner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_DELIMITER = ";";
    private static final String DEFAULT_DELIMITER_KEYWORD = "DELIMITER";
    private final DatabaseType dbType;

    public ScriptRunner(DatabaseType dbType) {
        this.dbType = dbType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, Reader reader) throws IOException, SQLException {
        try {
            boolean originalAutoCommit = connection.getAutoCommit();
            try {
                if (originalAutoCommit) {
                    connection.setAutoCommit(false);
                }
                this.doExecute(connection, reader);
            }
            finally {
                connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    private void doExecute(Connection connection, Reader reader) throws IOException, SQLException {
        StringBuffer command = null;
        try {
            String line;
            String delimiter = DEFAULT_DELIMITER;
            LineNumberReader lineReader = new LineNumberReader(reader);
            while ((line = lineReader.readLine()) != null) {
                if (command == null) {
                    command = new StringBuffer();
                }
                if ((line = line.trim()).length() < 1) continue;
                if (line.startsWith("--") || line.startsWith("#") || line.startsWith("//")) {
                    this.logger.debug(line);
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase((String)line, (String)DEFAULT_DELIMITER_KEYWORD)) {
                    delimiter = line.substring(10).trim();
                    continue;
                }
                if (command.length() == 0 && StringUtils.startsWithIgnoreCase((String)line, (String)"create ") && StringUtils.containsIgnoreCase((String)line, (String)" as ")) {
                    delimiter = line.substring(line.toLowerCase().lastIndexOf(" as ") + 4);
                    command.append(line);
                    command.append(" ");
                    continue;
                }
                if (line.contains(delimiter)) {
                    if (line.startsWith(delimiter)) {
                        delimiter = DEFAULT_DELIMITER;
                    }
                    if (!line.endsWith(delimiter)) continue;
                    command.append(line.substring(0, line.lastIndexOf(delimiter)));
                    this.executeStatement(connection, command.toString());
                    command = null;
                    continue;
                }
                command.append(line);
                command.append(" ");
            }
            if (command != null && command.length() > 0) {
                this.logger.info("Last statement in script is missing a terminating delimiter, executing anyway.");
                this.executeStatement(connection, command.toString());
            }
        }
        catch (SQLException e) {
            e.fillInStackTrace();
            this.logger.error("Error executing: " + command, (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            e.fillInStackTrace();
            this.logger.error("Error executing: " + command, (Throwable)e);
            throw e;
        }
    }

    private void executeStatement(Connection conn, String command) throws SQLException {
        Statement statement = conn.createStatement();
        this.logger.debug(command);
        boolean hasResults = statement.execute(command);
        ResultSet rs = statement.getResultSet();
        if (hasResults && rs != null) {
            int i;
            ResultSetMetaData md = rs.getMetaData();
            int cols = md.getColumnCount();
            for (i = 1; i <= cols; ++i) {
                String name = md.getColumnName(i);
                this.logger.debug(name + "\t");
            }
            while (rs.next()) {
                for (i = 1; i <= cols; ++i) {
                    String value = rs.getString(i);
                    this.logger.debug(value + "\t");
                }
            }
        }
        try {
            statement.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        Thread.yield();
    }
}

