/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileHandler
implements FileHandler {
    private static int uniqueNameCounter = -1;
    private AntUtils antUtils = new AntUtils();
    private FileUtils fileUtils = FileUtils.newFileUtils();

    private AntUtils getAntUtils() {
        return this.antUtils;
    }

    private FileUtils getFileUtils() {
        return this.fileUtils;
    }

    @Override
    public void copyFile(String source, String target) {
        this.copyFile(source, target, false);
    }

    @Override
    public void copyFile(String source, String target, boolean overwrite) {
        try {
            this.getFileUtils().copyFile(new File(source).getAbsolutePath(), new File(target).getAbsolutePath(), null, overwrite);
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy source file [" + source + "] to [" + target + "]", e);
        }
    }

    @Override
    public void copyFile(String source, String target, FilterChain filterChain) {
        this.copyFile(source, target, filterChain, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFile(String source, String target, FilterChain filterChain, String encoding) {
        try {
            FileInputStream fileIS = new FileInputStream(source);
            BufferedReader in = null;
            BufferedWriter out = null;
            try {
                String line;
                ChainReaderHelper helper = new ChainReaderHelper();
                helper.setBufferSize(8192);
                helper.setPrimaryReader((Reader)new BufferedReader(this.newReader(fileIS, encoding)));
                Vector<FilterChain> filterChains = new Vector<FilterChain>();
                filterChains.add(filterChain);
                helper.setFilterChains(filterChains);
                in = new BufferedReader(helper.getAssembledReader());
                out = new BufferedWriter(this.newWriter(target, encoding));
                while ((line = in.readLine()) != null) {
                    if (line.length() == 0) {
                        out.newLine();
                        continue;
                    }
                    out.write(line);
                    out.newLine();
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy source file [" + source + "] to [" + target + "] with FilterChain", e);
        }
    }

    @Override
    public void copyDirectory(String source, String target) {
        this.copyDirectory(source, target, new ArrayList<String>());
    }

    @Override
    public void copyDirectory(String source, String target, List<String> excludes) {
        try {
            Copy copyTask = (Copy)this.getAntUtils().createAntTask("copy");
            copyTask.setTodir(new File(target));
            FileSet fileSet = new FileSet();
            fileSet.setDir(new File(source));
            for (String excludeName : excludes) {
                fileSet.createExclude().setName(excludeName);
            }
            copyTask.addFileset(fileSet);
            copyTask.setFailOnError(true);
            copyTask.setIncludeEmptyDirs(true);
            copyTask.setOverwrite(true);
            copyTask.execute();
        }
        catch (BuildException e) {
            throw new CargoException("Failed to copy source directory [" + source + "] to [" + target + "]", e);
        }
    }

    @Override
    public String createDirectory(String parentDir, String name) {
        File dir = new File(parentDir, name);
        this.mkdirs(dir.getAbsolutePath());
        if (!dir.isDirectory() || !dir.exists()) {
            throw new CargoException("Couldn't create directory " + dir.getAbsolutePath());
        }
        return dir.getPath();
    }

    @Override
    public void copy(InputStream in, OutputStream out, int bufSize) {
        try {
            int length;
            byte[] buf = new byte[bufSize];
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy input stream [" + in.toString() + "] to output stream [" + out.toString() + "]", e);
        }
    }

    @Override
    public void copy(InputStream in, OutputStream out) {
        this.copy(in, out, 1024);
    }

    @Override
    public void replaceInFile(String file, Map<String, String> replacements) throws CargoException {
        this.replaceInFile(file, replacements, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceInFile(String file, Map<String, String> replacements, String encoding) throws CargoException {
        String fileContents = this.readTextFile(file, encoding);
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            if (!fileContents.contains(replacement.getKey())) {
                throw new CargoException("File " + file + " does not contain replacement key " + replacement.getKey());
            }
            fileContents = fileContents.replace(replacement.getKey(), replacement.getValue());
        }
        try {
            Writer fw = this.newWriter(file, encoding);
            try {
                fw.write(fileContents);
            }
            finally {
                fw.close();
            }
        }
        catch (IOException e) {
            throw new CargoException("Cannot write file " + file, e);
        }
    }

    @Override
    public String getTmpPath(String name) {
        return new File(new File(System.getProperty("java.io.tmpdir"), "cargo"), name).getPath();
    }

    @Override
    public synchronized String createUniqueTmpDirectory() {
        File tmpDir;
        if (uniqueNameCounter == -1) {
            uniqueNameCounter = new Random().nextInt() & 0xFFFF;
        }
        while ((tmpDir = new File(new File(System.getProperty("java.io.tmpdir")), "cargo/" + Integer.toString(++uniqueNameCounter))).exists()) {
        }
        tmpDir.deleteOnExit();
        this.mkdirs(tmpDir.getAbsolutePath());
        return tmpDir.getPath();
    }

    @Override
    public void delete(String path) {
        File pathAsFile = new File(path);
        if (pathAsFile.isDirectory()) {
            File[] children;
            for (File element : children = pathAsFile.listFiles()) {
                this.delete(element.getPath());
            }
        }
        pathAsFile.delete();
    }

    @Override
    public long getSize(String file) {
        File fileObject = new File(file).getAbsoluteFile();
        if (!fileObject.isFile()) {
            throw new CargoException("File [" + file + "] is not a file");
        }
        return fileObject.length();
    }

    @Override
    public InputStream getInputStream(String file) {
        FileInputStream is;
        try {
            is = new FileInputStream(new File(file).getAbsoluteFile());
        }
        catch (FileNotFoundException e) {
            throw new CargoException("Failed to find file [" + file + "]", e);
        }
        return is;
    }

    @Override
    public OutputStream getOutputStream(String file) {
        FileOutputStream os;
        String parent = this.getParent(file);
        if (parent != null) {
            this.mkdirs(parent);
        }
        try {
            os = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new CargoException("Failed to open output stream for file [" + file + "]", e);
        }
        return os;
    }

    @Override
    public String append(String path, String suffixToAppend) {
        String result = !path.endsWith("/") && !path.endsWith("\\") ? path + "/" + suffixToAppend : path + suffixToAppend;
        return result;
    }

    @Override
    public void mkdirs(String path) {
        File pathFile = new File(path);
        boolean success = false;
        for (int i = 0; i < 3 && !success; ++i) {
            success = pathFile.exists() ? true : pathFile.mkdirs();
        }
        if (!success) {
            throw new CargoException("Failed to create folders for path [" + path + "]");
        }
    }

    @Override
    public String getParent(String path) {
        return new File(path).getParent();
    }

    @Override
    public boolean exists(String path) {
        return new File(path).exists();
    }

    @Override
    public void createFile(String file) {
        try {
            new File(file).createNewFile();
        }
        catch (IOException e) {
            throw new CargoException("Failed to create file [" + file + "]", e);
        }
    }

    @Override
    public boolean isDirectoryEmpty(String dir) {
        return new File(dir).list().length == 0;
    }

    @Override
    public String getName(String file) {
        return new File(file).getName();
    }

    @Override
    public String getURL(String path) {
        URL result;
        try {
            result = new File(path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new CargoException("Failed to return URL for [" + path + "]", e);
        }
        return result.toString();
    }

    @Override
    public boolean isDirectory(String path) {
        return new File(path).isDirectory();
    }

    @Override
    public String[] getChildren(String directory) {
        File[] files = new File(directory).listFiles();
        String[] results = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            results[i] = files[i].getPath();
        }
        return results;
    }

    @Override
    public String getAbsolutePath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir"), file.getPath());
        }
        return file.getAbsolutePath();
    }

    @Override
    public String readTextFile(String file) {
        return this.readTextFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readTextFile(String file, String encoding) {
        String string;
        block8: {
            BufferedReader in = null;
            StringBuilder out = new StringBuilder();
            try {
                String str;
                in = new BufferedReader(this.newReader(this.getInputStream(file), encoding));
                while ((str = in.readLine()) != null) {
                    if (out.length() > 0) {
                        out.append(System.getProperty("line.separator"));
                    }
                    out.append(str);
                }
                string = out.toString();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CargoException("Failed to read text from file: " + file, e);
                }
            }
            in.close();
        }
        return string;
    }

    private Reader newReader(InputStream is, String encoding) throws IOException {
        if (encoding == null || encoding.length() <= 0) {
            return new InputStreamReader(is);
        }
        return new InputStreamReader(is, encoding);
    }

    private Writer newWriter(String file, String encoding) throws IOException {
        String parent = this.getParent(file);
        if (!this.isDirectory(parent)) {
            this.mkdirs(parent);
        }
        if (encoding == null || encoding.length() <= 0) {
            return new FileWriter(file);
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
    }
}

