/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.util.Properties;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.internal.util.PropertyUtils;
import org.codehaus.cargo.container.tomcat.internal.AbstractCatalinaStandaloneLocalConfiguration;
import org.codehaus.cargo.container.tomcat.internal.Tomcat4xConfigurationBuilder;

public class Tomcat4xStandaloneLocalConfiguration
extends AbstractCatalinaStandaloneLocalConfiguration {
    public Tomcat4xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    protected ConfigurationBuilder createConfigurationBuilder(LocalContainer container) {
        return new Tomcat4xConfigurationBuilder();
    }

    protected void setupManager(LocalContainer container) {
        String from = ((InstalledLocalContainer)container).getHome();
        String to = this.getHome();
        this.getFileHandler().copyDirectory(from + "/server/webapps/manager", to + "/server/webapps/manager");
        this.getFileHandler().copyFile(from + "/webapps/manager.xml", to + "/webapps/manager.xml");
    }

    protected void setupTransactionManager() {
        Resource transactionManagerResource = new Resource("UserTransaction", "javax.transaction.UserTransaction");
        Properties parameters = new Properties();
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"jotm.timeout", (Object)"60");
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"factory", (Object)"org.objectweb.jotm.UserTransactionFactory");
        transactionManagerResource.setParameters(PropertyUtils.toMap((Properties)parameters));
        this.getResources().add(transactionManagerResource);
    }

    protected String getXpathForResourcesParent() {
        return "//Engine/DefaultContext";
    }

    public String toString() {
        return "Tomcat 4.x Standalone Configuration";
    }

    protected String getOrCreateResourceConfigurationFile(Resource rs, LocalContainer container) {
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        return this.getFileHandler().append(confDir, "server.xml");
    }
}

