/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.internal.util.PropertyUtils;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.tomcat.internal.AbstractCatalinaStandaloneLocalConfiguration;
import org.codehaus.cargo.container.tomcat.internal.Tomcat5And6xConfigurationBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tomcat5xStandaloneLocalConfiguration
extends AbstractCatalinaStandaloneLocalConfiguration {
    private Tomcat5And6xConfigurationBuilder configurationBuilder;

    public Tomcat5xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.tomcat.connector.emptySessionPath", "true");
        this.configurationBuilder = new Tomcat5And6xConfigurationBuilder();
    }

    protected ConfigurationBuilder createConfigurationBuilder(LocalContainer container) {
        return this.configurationBuilder;
    }

    @Override
    protected void setupManager(LocalContainer container) {
        if (!(container instanceof EmbeddedLocalContainer)) {
            String from = ((InstalledLocalContainer)container).getHome();
            String to = this.getHome();
            this.getFileHandler().copyDirectory(from + "/server/webapps/manager", to + "/server/webapps/manager");
            this.getFileHandler().copyFile(from + "/conf/Catalina/localhost/manager.xml", to + "/conf/Catalina/localhost/manager.xml");
        }
    }

    @Override
    protected FilterChain createTomcatFilterChain() {
        FilterChain filterChain = super.createTomcatFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.connector.emptySessionPath", this.getPropertyValue("cargo.tomcat.connector.emptySessionPath"));
        return filterChain;
    }

    @Override
    public String toString() {
        return "Tomcat 5.x Standalone Configuration";
    }

    @Override
    protected Set<String> getConfFiles() {
        Set<String> files = super.getConfFiles();
        files.add("logging.properties");
        files.add("catalina.properties");
        files.add("context.xml");
        return files;
    }

    @Override
    protected void setupTransactionManager() {
        Resource transactionManagerResource = new Resource("UserTransaction", "javax.transaction.UserTransaction");
        Properties parameters = new Properties();
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"jotm.timeout", (Object)"60");
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"factory", (Object)"org.objectweb.jotm.UserTransactionFactory");
        transactionManagerResource.setParameters(PropertyUtils.toMap((Properties)parameters));
        this.getResources().add(transactionManagerResource);
    }

    protected String getXpathForResourcesParent() {
        return "//Context";
    }

    protected String getOrCreateResourceConfigurationFile(Resource rs, LocalContainer container) {
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        return this.getFileHandler().append(confDir, "context.xml");
    }

    @Override
    protected String getTomcatLoggingLevel(String cargoLoggingLevel) {
        String level = LoggingLevel.LOW.equalsLevel(cargoLoggingLevel) ? "WARNING" : (LoggingLevel.MEDIUM.equalsLevel(cargoLoggingLevel) ? "INFO" : "FINE");
        return level;
    }

    @Override
    protected String createContextToken(WAR deployable) {
        StringBuilder contextTokenValue = new StringBuilder();
        contextTokenValue.append("<Context");
        contextTokenValue.append(" path=\"");
        if (!"".equals(deployable.getContext()) && !"/".equals(deployable.getContext())) {
            contextTokenValue.append("/" + deployable.getContext());
        }
        contextTokenValue.append("\"");
        contextTokenValue.append(" docBase=\"");
        contextTokenValue.append(new File(deployable.getFile()).getAbsolutePath());
        contextTokenValue.append("\"");
        contextTokenValue.append(" reloadable=\"");
        contextTokenValue.append(this.getPropertyValue("cargo.tomcat.context.reloadable"));
        contextTokenValue.append("\"");
        contextTokenValue.append(">");
        contextTokenValue.append("</Context>");
        return contextTokenValue.toString();
    }
}

