/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.ServletContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;

public abstract class AbstractCatalinaInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    private ContainerCapability capability = new ServletContainerCapability();
    private String version;

    public AbstractCatalinaInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    protected final String getVersion(String defaultVersion) {
        String version = this.version;
        if (version == null) {
            try {
                JarFile catalinaJar = new JarFile(new File(this.getHome(), "server/lib/catalina.jar"));
                ZipEntry entry = catalinaJar.getEntry("org/apache/catalina/util/ServerInfo.properties");
                if (entry != null) {
                    Properties props = new Properties();
                    props.load(catalinaJar.getInputStream(entry));
                    String serverInfo = props.getProperty("server.info");
                    int slashPos = serverInfo.indexOf(47);
                    if (slashPos > 0) {
                        version = serverInfo.substring(slashPos + 1);
                    }
                } else {
                    version = "4.0.x";
                }
            }
            catch (Exception e) {
                version = defaultVersion;
                this.getLogger().debug("Failed to find Tomcat version, base error [" + e.getMessage() + "]", ((Object)((Object)this)).getClass().getName());
            }
            this.getLogger().debug("Parsed Tomcat version = [" + version + "]", ((Object)((Object)this)).getClass().getName());
            this.version = version;
        }
        return version;
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    public void doStart(JvmLauncher java) throws Exception {
        this.invokeContainer("start", java);
    }

    public void doStop(JvmLauncher java) throws Exception {
        this.invokeContainer("stop", java);
    }

    protected void invokeContainer(String action, JvmLauncher java) throws Exception {
        String base = this.getFileHandler().getAbsolutePath(this.getConfiguration().getHome());
        java.setSystemProperty("catalina.home", this.getFileHandler().getAbsolutePath(this.getHome()));
        java.setSystemProperty("catalina.base", base);
        File tempFile = new File(this.getConfiguration().getHome(), "temp");
        java.setSystemProperty("java.io.tmpdir", this.getFileHandler().getAbsolutePath(tempFile.getAbsolutePath()));
        java.setSystemProperty("java.util.logging.config.file", this.getFileHandler().append(base, "conf/logging.properties"));
        java.addClasspathEntries(new File[]{new File(this.getHome(), "bin/bootstrap.jar")});
        this.addToolsJarToClasspath(java);
        java.setMainClass("org.apache.catalina.startup.Bootstrap");
        java.addAppArguments(new String[]{action});
        java.start();
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        if (!waitForStarting) {
            LocalConfiguration config = this.getConfiguration();
            this.waitForPortShutdown(new String[]{config.getPropertyValue("cargo.servlet.port"), config.getPropertyValue("cargo.rmi.port"), config.getPropertyValue("cargo.tomcat.ajp.port")});
            return;
        }
        super.waitForCompletion(waitForStarting);
    }
}

