/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.configuration;

import java.lang.reflect.Constructor;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.generic.AbstractFactoryRegistry;
import org.codehaus.cargo.generic.configuration.ConfigurationFactory;
import org.codehaus.cargo.generic.internal.util.FullContainerIdentity;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurationFactory
extends AbstractIntrospectionGenericHintFactory<Configuration>
implements ConfigurationFactory {
    private FileHandler fileHandler = new DefaultFileHandler();

    public DefaultConfigurationFactory() {
        this(null);
    }

    public DefaultConfigurationFactory(ClassLoader classLoader) {
        AbstractFactoryRegistry.register(classLoader, this);
    }

    @Override
    public boolean isConfigurationRegistered(String containerId, ContainerType containerType, ConfigurationType configurationType) {
        return this.hasMapping(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()));
    }

    @Override
    public void registerConfiguration(String containerId, ContainerType containerType, ConfigurationType configurationType, Class<? extends Configuration> configurationClass) {
        this.registerImplementation(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()), configurationClass);
    }

    public void registerConfiguration(String containerId, ContainerType containerType, ConfigurationType configurationType, String configurationClassName) {
        this.registerImplementation(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()), configurationClassName);
    }

    @Override
    public Class<? extends Configuration> getConfigurationClass(String containerId, ContainerType containerType, ConfigurationType configurationType) {
        return this.getMapping(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()));
    }

    @Override
    public Configuration createConfiguration(String containerId, ContainerType containerType, ConfigurationType configurationType) {
        return this.createConfiguration(containerId, containerType, configurationType, null);
    }

    @Override
    public Configuration createConfiguration(String containerId, ContainerType containerType, ConfigurationType configurationType, String home) {
        ConfigurationFactoryParameters parameters = new ConfigurationFactoryParameters();
        parameters.home = home;
        return (Configuration)this.createImplementation(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()), parameters, "configuration");
    }

    @Override
    protected Constructor<? extends Configuration> getConstructor(Class<? extends Configuration> configurationClass, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        Constructor<? extends Configuration> constructor;
        if (ConfigurationType.toType((String)hint) == ConfigurationType.RUNTIME) {
            constructor = configurationClass.getConstructor(new Class[0]);
        } else if (ConfigurationType.toType((String)hint) == ConfigurationType.EXISTING || ConfigurationType.toType((String)hint) == ConfigurationType.STANDALONE) {
            constructor = configurationClass.getConstructor(String.class);
        } else {
            throw new ContainerException("Unknown configuration type [" + hint + "]");
        }
        return constructor;
    }

    @Override
    protected Configuration createInstance(Constructor<? extends Configuration> constructor, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        Configuration instance;
        String home = ((ConfigurationFactoryParameters)parameters).home;
        if (ConfigurationType.toType((String)hint) == ConfigurationType.RUNTIME) {
            if (home != null) {
                throw new ContainerException("The configuration home parameter should not be specified for runtime configurations");
            }
            instance = constructor.newInstance(new Object[0]);
        } else if (ConfigurationType.toType((String)hint) == ConfigurationType.EXISTING || ConfigurationType.toType((String)hint) == ConfigurationType.STANDALONE) {
            if (home == null) {
                if (ConfigurationType.toType((String)hint) == ConfigurationType.EXISTING) {
                    throw new ContainerException("The configuration home parameter must be specified for existing configurations");
                }
                home = this.fileHandler.getTmpPath("conf");
            }
            instance = constructor.newInstance(home);
        } else {
            throw new ContainerException("Unknown configuration type [" + hint + "]");
        }
        return instance;
    }

    private static class ConfigurationFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public String home;

        private ConfigurationFactoryParameters() {
        }
    }
}

