/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client;

import edu.yale.its.tp.cas.util.SecureURL;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceTicketValidator {
    private String casValidateUrl;
    private String proxyCallbackUrl;
    private String st;
    private String service;
    private String pgtIou;
    private String user;
    private String errorCode;
    private String errorMessage;
    private String entireResponse;
    private boolean renew;
    private boolean attemptedAuthentication;
    private boolean successfulAuthentication;

    private /* synthetic */ void finit$() {
        this.renew = false;
    }

    static /* synthetic */ String access$5(ServiceTicketValidator serviceTicketValidator) {
        return serviceTicketValidator.errorCode;
    }

    static /* synthetic */ String access$4(ServiceTicketValidator serviceTicketValidator) {
        return serviceTicketValidator.errorMessage;
    }

    static /* synthetic */ boolean access$3(ServiceTicketValidator serviceTicketValidator) {
        return serviceTicketValidator.successfulAuthentication;
    }

    static /* synthetic */ String access$2(ServiceTicketValidator serviceTicketValidator) {
        return serviceTicketValidator.pgtIou;
    }

    public static void main(String[] stringArray) throws Exception {
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        ServiceTicketValidator serviceTicketValidator = new ServiceTicketValidator();
        serviceTicketValidator.setCasValidateUrl("https://portal1.wss.yale.edu/cas/serviceValidate");
        serviceTicketValidator.setProxyCallbackUrl("https://portal1.wss.yale.edu/casProxy/receptor");
        serviceTicketValidator.setService(stringArray[0]);
        serviceTicketValidator.setServiceTicket(stringArray[1]);
        serviceTicketValidator.validate();
        System.out.println(serviceTicketValidator.getResponse());
        System.out.println();
        if (serviceTicketValidator.isAuthenticationSuccesful()) {
            System.out.println("user: " + serviceTicketValidator.getUser());
            System.out.println("pgtIou: " + serviceTicketValidator.getPgtIou());
        } else {
            System.out.println("error code: " + serviceTicketValidator.getErrorCode());
            System.out.println("error message: " + serviceTicketValidator.getErrorMessage());
        }
    }

    public void setCasValidateUrl(String string) {
        this.casValidateUrl = string;
    }

    public String getCasValidateUrl() {
        return this.casValidateUrl;
    }

    public void setProxyCallbackUrl(String string) {
        this.proxyCallbackUrl = string;
    }

    public void setRenew(boolean bl) {
        this.renew = bl;
    }

    public String getProxyCallbackUrl() {
        return this.proxyCallbackUrl;
    }

    public void setServiceTicket(String string) {
        this.st = string;
    }

    public void setService(String string) {
        this.service = string;
    }

    public String getUser() {
        return this.user;
    }

    public String getPgtIou() {
        return this.pgtIou;
    }

    public boolean isAuthenticationSuccesful() {
        return this.successfulAuthentication;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getResponse() {
        return this.entireResponse;
    }

    public void validate() throws IOException, SAXException, ParserConfigurationException {
        String string;
        if (this.casValidateUrl == null || this.st == null) {
            throw new IllegalStateException("must set validation URL and ticket");
        }
        this.clear();
        this.attemptedAuthentication = true;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.casValidateUrl);
        if (this.casValidateUrl.indexOf(63) == -1) {
            stringBuffer.append('?');
        } else {
            stringBuffer.append('&');
        }
        stringBuffer.append("service=" + this.service + "&ticket=" + this.st);
        if (this.proxyCallbackUrl != null) {
            stringBuffer.append("&pgtUrl=" + this.proxyCallbackUrl);
        }
        if (this.renew) {
            stringBuffer.append("&renew=true");
        }
        String string2 = stringBuffer.toString();
        this.entireResponse = string = SecureURL.retrieve(string2);
        if (string != null) {
            XMLReader xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
            xMLReader.setContentHandler(this.newHandler());
            xMLReader.parse(new InputSource(new StringReader(string)));
        }
    }

    protected DefaultHandler newHandler() {
        return new Handler(this);
    }

    protected void clear() {
        this.errorMessage = null;
        this.pgtIou = null;
        this.user = null;
        this.attemptedAuthentication = false;
        this.successfulAuthentication = false;
    }

    public ServiceTicketValidator() {
        this.finit$();
    }

    protected class Handler
    extends DefaultHandler {
        private /* synthetic */ ServiceTicketValidator this$0;
        protected static final String AUTHENTICATION_SUCCESS = "cas:authenticationSuccess";
        protected static final String AUTHENTICATION_FAILURE = "cas:authenticationFailure";
        protected static final String PROXY_GRANTING_TICKET = "cas:proxyGrantingTicket";
        protected static final String USER = "cas:user";
        protected StringBuffer currentText;
        protected boolean authenticationSuccess;
        protected boolean authenticationFailure;
        protected String netid;
        protected String pgtIou;
        protected String errorCode;
        protected String errorMessage;

        private /* synthetic */ void finit$() {
            this.currentText = new StringBuffer();
            this.authenticationSuccess = false;
            this.authenticationFailure = false;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.currentText = new StringBuffer();
            if (string3.equals(AUTHENTICATION_SUCCESS)) {
                this.authenticationSuccess = true;
            } else if (string3.equals(AUTHENTICATION_FAILURE)) {
                this.authenticationFailure = true;
                this.errorCode = attributes.getValue("code");
                if (this.errorCode != null) {
                    this.errorCode = this.errorCode.trim();
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            this.currentText.append(cArray, n, n2);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.authenticationSuccess) {
                if (string3.equals(USER)) {
                    this.this$0.user = this.currentText.toString().trim();
                }
                if (string3.equals(PROXY_GRANTING_TICKET)) {
                    this.pgtIou = this.currentText.toString().trim();
                }
            } else if (this.authenticationFailure && string3.equals(AUTHENTICATION_FAILURE)) {
                this.errorMessage = this.currentText.toString().trim();
            }
        }

        public void endDocument() throws SAXException {
            if (this.authenticationSuccess) {
                this.this$0.user = this.this$0.user;
                this.this$0.pgtIou = this.pgtIou;
                this.this$0.successfulAuthentication = true;
            } else if (this.authenticationFailure) {
                this.this$0.errorMessage = this.errorMessage;
                this.this$0.errorCode = this.errorCode;
                this.this$0.successfulAuthentication = false;
            } else {
                throw new SAXException("no indication of success of failure from CAS");
            }
        }

        Handler(ServiceTicketValidator serviceTicketValidator) {
            this.this$0 = serviceTicketValidator;
            this.finit$();
        }
    }
}

