/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client.filter;

import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import edu.yale.its.tp.cas.client.Util;
import edu.yale.its.tp.cas.client.filter.CASFilterRequestWrapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CASFilter
implements Filter {
    public static final String CAS_FILTER_USER = "edu.yale.its.tp.cas.client.filter.user";
    private String casLogin;
    private String casValidate;
    private String casAuthorizedProxy;
    private String casServiceUrl;
    private String casRenew;
    private String casServerName;
    private boolean wrapRequest;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.casLogin = filterConfig.getInitParameter("edu.yale.its.tp.cas.client.filter.loginUrl");
        this.casValidate = filterConfig.getInitParameter("edu.yale.its.tp.cas.client.filter.validateUrl");
        this.casServiceUrl = filterConfig.getInitParameter("edu.yale.its.tp.cas.client.filter.serviceUrl");
        this.casAuthorizedProxy = filterConfig.getInitParameter("edu.yale.its.tp.cas.client.filter.authorizedProxy");
        this.casRenew = filterConfig.getInitParameter("edu.yale.its.tp.cas.client.filter.renew");
        this.casServerName = filterConfig.getInitParameter("edu.yale.its.tp.cas.client.filter.serverName");
        this.wrapRequest = Boolean.valueOf(filterConfig.getInitParameter("edu.yale.its.tp.cas.client.filter.wrapRequest"));
    }

    public void doFilter(ServletRequest object, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        HttpSession httpSession;
        if (!(object instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("CASFilter protects only HTTP resources");
        }
        if (this.wrapRequest) {
            object = new CASFilterRequestWrapper((HttpServletRequest)object);
        }
        if ((httpSession = ((HttpServletRequest)object).getSession()) != null && httpSession.getAttribute(CAS_FILTER_USER) != null) {
            filterChain.doFilter(object, servletResponse);
            return;
        }
        String string = object.getParameter("ticket");
        if (string == null || string.equals("")) {
            if (this.casLogin == null) {
                throw new ServletException("When CASFilter protects pages that do not receive a 'ticket' parameter, it needs a edu.yale.its.tp.cas.client.filter.loginUrl filter parameter");
            }
            ((HttpServletResponse)servletResponse).sendRedirect(this.casLogin + "?service=" + this.getService((HttpServletRequest)object) + (this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : ""));
            return;
        }
        String string2 = this.getAuthenticatedUser((HttpServletRequest)object);
        if (string2 == null) {
            throw new ServletException("Unexpected CAS authentication error");
        }
        if (httpSession != null) {
            httpSession.setAttribute(CAS_FILTER_USER, (Object)string2);
        }
        filterChain.doFilter(object, servletResponse);
    }

    public void destroy() {
    }

    private String getAuthenticatedUser(HttpServletRequest httpServletRequest) throws ServletException {
        ProxyTicketValidator proxyTicketValidator = null;
        try {
            proxyTicketValidator = new ProxyTicketValidator();
            proxyTicketValidator.setCasValidateUrl(this.casValidate);
            proxyTicketValidator.setServiceTicket(httpServletRequest.getParameter("ticket"));
            proxyTicketValidator.setService(this.getService(httpServletRequest));
            proxyTicketValidator.setRenew(Boolean.valueOf(this.casRenew));
            proxyTicketValidator.validate();
            if (!proxyTicketValidator.isAuthenticationSuccesful()) {
                throw new ServletException("CAS authentication error: " + proxyTicketValidator.getErrorCode() + ": " + proxyTicketValidator.getErrorMessage());
            }
            if (proxyTicketValidator.getProxyList().size() != 0) {
                if (this.casAuthorizedProxy == null) {
                    throw new ServletException("this page does not accept proxied tickets");
                }
                boolean bl = false;
                String string = (String)proxyTicketValidator.getProxyList().get(0);
                StringTokenizer stringTokenizer = new StringTokenizer(this.casAuthorizedProxy);
                while (stringTokenizer.hasMoreTokens()) {
                    if (!string.equals(stringTokenizer.nextToken())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new ServletException("unauthorized top-level proxy: '" + proxyTicketValidator.getProxyList().get(0) + "'");
                }
            }
            return proxyTicketValidator.getUser();
        }
        catch (SAXException sAXException) {
            String string = "";
            if (proxyTicketValidator != null) {
                string = proxyTicketValidator.getResponse();
            }
            throw new ServletException(sAXException + " " + string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ServletException((Throwable)parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
    }

    private String getService(HttpServletRequest httpServletRequest) throws ServletException {
        if (this.casServerName == null && this.casServiceUrl == null) {
            throw new ServletException("need one of the following configuration parameters: edu.yale.its.tp.cas.client.filter.serviceUrl or edu.yale.its.tp.cas.client.filter.serverName");
        }
        if (this.casServiceUrl != null) {
            return URLEncoder.encode(this.casServiceUrl);
        }
        return Util.getService(httpServletRequest, this.casServerName);
    }
}

