/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cas;

import edu.yale.its.tp.cas.client.ServiceTicketValidator;
import edu.yale.its.tp.cas.util.SecureURL;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import play.Logger;
import play.Play;
import play.cache.Cache;
import play.modules.cas.models.CASUser;
import play.mvc.Router;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CASUtils {
    public static String getCasLoginUrl(Boolean possibleGateway) {
        String casLoginUrl = Play.configuration.getProperty("cas.loginUrl");
        casLoginUrl = casLoginUrl + "?service=" + CASUtils.getCasServiceUrl();
        if (possibleGateway.booleanValue() && Boolean.valueOf(Play.configuration.getProperty("cas.gateway")).booleanValue()) {
            casLoginUrl = casLoginUrl + "&gateway=true";
        }
        Logger.debug((String)("[SecureCAS]: login CAS URL is " + casLoginUrl), (Object[])new Object[0]);
        return casLoginUrl;
    }

    public static String getCasLogoutUrl() {
        return Play.configuration.getProperty("cas.logoutUrl");
    }

    private static String getCasServiceUrl() {
        String casServiceUrl = Play.configuration.getProperty("application.url");
        casServiceUrl = casServiceUrl + Router.reverse((String)"modules.cas.SecureCAS.authenticate").url;
        return casServiceUrl;
    }

    private static String getCasProxyCallBackUrl() {
        String casProxyCallBackUrl = "";
        if (Play.configuration.getProperty("application.url.ssl") != null && !Play.configuration.getProperty("application.url.ssl").equals("")) {
            casProxyCallBackUrl = Play.configuration.getProperty("application.url.ssl");
        } else {
            casProxyCallBackUrl = Play.configuration.getProperty("application.url");
            casProxyCallBackUrl = casProxyCallBackUrl.replaceFirst("http://", "https://");
        }
        casProxyCallBackUrl = casProxyCallBackUrl + Router.reverse((String)"modules.cas.SecureCAS.pgtCallBack").url;
        return casProxyCallBackUrl;
    }

    private static String getCasProxyUrl() {
        String casProxyUrl = Play.configuration.getProperty("cas.proxyUrl");
        return casProxyUrl;
    }

    private static Boolean isProxyCas() {
        Boolean isProxyCas = Boolean.FALSE;
        if (Play.configuration.getProperty("cas.proxyUrl") != null && !Play.configuration.getProperty("cas.proxyUrl").equals("")) {
            isProxyCas = Boolean.TRUE;
        }
        return isProxyCas;
    }

    public static CASUser valideCasTicket(String ticket) throws IOException, SAXException, ParserConfigurationException {
        ServiceTicketValidator sv = new ServiceTicketValidator();
        sv.setCasValidateUrl(Play.configuration.getProperty("cas.validateUrl"));
        if (CASUtils.isProxyCas().booleanValue()) {
            sv.setProxyCallbackUrl(CASUtils.getCasProxyCallBackUrl());
        }
        sv.setService(CASUtils.getCasServiceUrl());
        sv.setServiceTicket(ticket);
        sv.validate();
        CASUser user = null;
        if (sv.isAuthenticationSuccesful()) {
            Map<String, String> casAttribut = null;
            casAttribut = CASUtils.getCasAttributes(sv.getResponse());
            user = new CASUser();
            user.setUsername(sv.getUser());
            user.setAttribut(casAttribut);
            if (CASUtils.isProxyCas().booleanValue()) {
                String pgt = (String)Cache.get((String)sv.getPgtIou());
                Cache.delete((String)sv.getPgtIou());
                Cache.add((String)("pgt_" + user.getUsername()), (Object)pgt);
            }
        }
        return user;
    }

    private static Map<String, String> getCasAttributes(String xml) throws SAXException {
        Map<String, String> casAttribut = null;
        if (xml.indexOf("<cas:attributes>") != -1) {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        }
        return casAttribut;
    }

    public static String getProxyTicket(String username, String serviceName) throws IOException {
        String proxyTicket = null;
        String pgt = (String)Cache.get((String)("pgt_" + username));
        String url = CASUtils.getCasProxyUrl() + "?pgt=" + pgt + "&targetService=" + serviceName;
        String response = SecureURL.retrieve((String)url);
        if (response.indexOf("<cas:proxySuccess>") != -1 && response.indexOf("<cas:proxyTicket>") != -1) {
            int startIndex = response.indexOf("<cas:proxyTicket>") + "<cas:proxyTicket>".length();
            int endIndex = response.indexOf("</cas:proxyTicket>");
            proxyTicket = response.substring(startIndex, endIndex);
        } else {
            Logger.error((String)("CAS server responded with error for request [" + url + "].  Full response was [" + response + "]"), (Object[])new Object[0]);
        }
        Logger.debug((String)("[SecureCAS]: PT for user " + username + " and service " + serviceName + " is " + proxyTicket), (Object[])new Object[0]);
        return proxyTicket;
    }
}

