/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client.filter;

import edu.yale.its.tp.cas.client.CASReceipt;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyChainScrutinizerFilter
implements Filter {
    private static final Log log = LogFactory.getLog((Class)(class$edu$yale$its$tp$cas$client$filter$ProxyChainScrutinizerFilter == null ? (class$edu$yale$its$tp$cas$client$filter$ProxyChainScrutinizerFilter = ProxyChainScrutinizerFilter.class$("edu.yale.its.tp.cas.client.filter.ProxyChainScrutinizerFilter")) : class$edu$yale$its$tp$cas$client$filter$ProxyChainScrutinizerFilter));
    private Set authorizedProxyChains = new HashSet();
    public static final String AUTHORIZED_PROXIES_INITPARAM = "edu.yale.its.tp.cas.client.filter.authorizedProxyChains";
    static /* synthetic */ Class class$edu$yale$its$tp$cas$client$filter$ProxyChainScrutinizerFilter;
    static /* synthetic */ Class class$edu$yale$its$tp$cas$client$CASReceipt;

    public void init(FilterConfig config) throws ServletException {
        String authorizedProxiesString = config.getInitParameter(AUTHORIZED_PROXIES_INITPARAM);
        if (authorizedProxiesString == null) {
            throw new ServletException("The filter initialization parameter edu.yale.its.tp.cas.client.filter.authorizedProxyChains must be a semicolon delimited list of authorized filter chains.");
        }
        LinkedList<String> currentAuthorizedChain = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(authorizedProxiesString);
        if (!tokenizer.hasMoreTokens()) {
            throw new ServletException("The filter initialization paramter edu.yale.its.tp.cas.client.filter.authorizedProxyChains must contain at least one token.");
        }
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(";")) {
                this.authorizedProxyChains.add(currentAuthorizedChain);
                currentAuthorizedChain = new LinkedList();
                continue;
            }
            if (!token.toUpperCase().startsWith("HTTPS://")) {
                throw new ServletException("Illegal authorized proxy chain element [" + token + "] in value of filter initialization parameter " + AUTHORIZED_PROXIES_INITPARAM);
            }
            currentAuthorizedChain.add(token);
        }
        if (!currentAuthorizedChain.isEmpty()) {
            this.authorizedProxyChains.add(currentAuthorizedChain);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Configured filter named [" + config.getFilterName() + "] as " + this.toString()));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain fc) throws IOException, ServletException {
        if (this.isRequestAuthorized(request)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Filter " + this + " is passing through request " + request));
            }
            fc.doFilter(request, response);
            return;
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Request was unauthorized (probably not an HttpServletRequest at all) and response was not an HttpServletResponse so couldn't send 403/Forbidden.");
        }
        log.info((Object)"Sending FORBIDDEN.");
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.sendError(403);
    }

    private boolean isRequestAuthorized(ServletRequest request) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering isRequestAuthorized(" + request + ")"));
        }
        if (!(request instanceof HttpServletRequest)) {
            log.warn((Object)"request was not of expected type HttpServletRequest - considering request unauthorized.");
            return false;
        }
        HttpSession session = ((HttpServletRequest)request).getSession(false);
        if (session == null) {
            log.info((Object)"No HttpSession was established into which a CASReceipt might have been stored - considering request unauthorized.");
            return false;
        }
        Object potentialReceipt = session.getAttribute("edu.yale.its.tp.cas.client.filter.receipt");
        if (potentialReceipt == null) {
            log.info((Object)"CASReceipt was not present in HttpSession - considered request unauthorized.");
            return false;
        }
        if (!(potentialReceipt instanceof CASReceipt)) {
            log.warn((Object)("An object was present in the session attribute edu.yale.its.tp.cas.client.filter.receipt but it wasn't of type " + (class$edu$yale$its$tp$cas$client$CASReceipt == null ? (class$edu$yale$its$tp$cas$client$CASReceipt = ProxyChainScrutinizerFilter.class$("edu.yale.its.tp.cas.client.CASReceipt")) : class$edu$yale$its$tp$cas$client$CASReceipt).getName()));
            return false;
        }
        CASReceipt receipt = (CASReceipt)potentialReceipt;
        if (!this.authorizedProxyChains.contains(receipt.getProxyList())) {
            log.info((Object)("CAS receipt: " + receipt + " did not present a proxy chain among those authorized: " + this.authorizedProxyChains + " - considering request unauthorized."));
            return false;
        }
        log.trace((Object)"returning from isRequestAuthorized() with true");
        return true;
    }

    public void destroy() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" authorizedProxyChains:").append(this.authorizedProxyChains);
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

