/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cas;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import play.Logger;
import play.Play;
import play.cache.Cache;
import play.libs.WS;
import play.modules.cas.models.CASUser;
import play.mvc.Router;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CASUtils {
    public static String getCasLoginUrl(Boolean possibleGateway) {
        String casLoginUrl = CASUtils.isCasMockServer() != false ? Router.getFullUrl((String)"modules.cas.MockServer.login") : Play.configuration.getProperty("cas.loginUrl");
        casLoginUrl = casLoginUrl + "?service=" + CASUtils.getCasServiceUrl();
        if (possibleGateway.booleanValue() && Boolean.valueOf(Play.configuration.getProperty("cas.gateway")).booleanValue()) {
            casLoginUrl = casLoginUrl + "&gateway=true";
        }
        Logger.debug((String)("[SecureCAS]: login CAS URL is " + casLoginUrl), (Object[])new Object[0]);
        return casLoginUrl;
    }

    public static String getCasLogoutUrl() {
        if (CASUtils.isCasMockServer().booleanValue()) {
            return Router.getFullUrl((String)"modules.cas.MockServer.logout");
        }
        return Play.configuration.getProperty("cas.logoutUrl");
    }

    private static String getCasServiceUrl() {
        String casServiceUrl = Router.getFullUrl((String)"modules.cas.SecureCAS.authenticate");
        return casServiceUrl;
    }

    private static String getCasServiceValidateUrl() {
        String casServiceValidateUrl = CASUtils.isCasMockServer() != false ? Router.getFullUrl((String)"modules.cas.MockServer.serviceValidate") : Play.configuration.getProperty("cas.validateUrl");
        return casServiceValidateUrl;
    }

    private static String getCasProxyCallBackUrl() {
        String casProxyCallBackUrl = Router.getFullUrl((String)"modules.cas.SecureCAS.pgtCallBack");
        if (!casProxyCallBackUrl.contains("https") && !CASUtils.isCasMockServer().booleanValue()) {
            casProxyCallBackUrl = Play.configuration.getProperty("application.baseUrl.ssl") != null && !Play.configuration.getProperty("application.baseUrl.ssl").equals("") ? Play.configuration.getProperty("application.baseUrl.ssl") : casProxyCallBackUrl.replaceFirst("http://", "https://");
        }
        return casProxyCallBackUrl;
    }

    private static String getCasProxyUrl() {
        String casProxyUrl = CASUtils.isCasMockServer() != false ? Router.getFullUrl((String)"modules.cas.MockServer.proxy") : Play.configuration.getProperty("cas.proxyUrl");
        return casProxyUrl;
    }

    private static Boolean isProxyCas() {
        Boolean isProxyCas = Boolean.FALSE;
        if (Play.configuration.getProperty("cas.proxyUrl") != null && !Play.configuration.getProperty("cas.proxyUrl").equals("")) {
            isProxyCas = Boolean.TRUE;
        }
        return isProxyCas;
    }

    public static Boolean isCasMockServer() {
        Boolean isCasMockServer = Boolean.FALSE;
        if (Play.configuration.getProperty("cas.mockserver") != null && Play.configuration.getProperty("cas.mockserver").equals("true") && Play.mode == Play.Mode.DEV) {
            isCasMockServer = Boolean.TRUE;
        }
        return isCasMockServer;
    }

    public static CASUser valideCasTicket(String ticket) throws IOException, SAXException, ParserConfigurationException, InterruptedException, ExecutionException {
        String casValidationTicketUrl = CASUtils.getCasServiceValidateUrl();
        casValidationTicketUrl = casValidationTicketUrl + "?service=" + CASUtils.getCasServiceUrl();
        casValidationTicketUrl = casValidationTicketUrl + "&ticket=" + ticket;
        if (CASUtils.isProxyCas().booleanValue()) {
            casValidationTicketUrl = casValidationTicketUrl + "&pgtUrl=" + CASUtils.getCasProxyCallBackUrl();
        }
        Logger.debug((String)("[SecureCAS]: validate cas ticket by calling " + casValidationTicketUrl), (Object[])new Object[0]);
        Document response = WS.url((String)casValidationTicketUrl).get().getXml();
        NodeList list = response.getElementsByTagName("cas:authenticationSuccess");
        CASUser user = null;
        if (list.getLength() > 0) {
            Map<String, String> casAttribut = null;
            casAttribut = CASUtils.getCasAttributes(response);
            user = new CASUser();
            user.setUsername(response.getElementsByTagName("cas:user").item(0).getTextContent());
            user.setAttribut(casAttribut);
            if (CASUtils.isProxyCas().booleanValue()) {
                String PGTIOU = response.getElementsByTagName("cas:proxyGrantingTicket").item(0).getTextContent();
                String pgt = (String)Cache.get((String)PGTIOU);
                Cache.delete((String)PGTIOU);
                Cache.add((String)("pgt_" + user.getUsername()), (Object)pgt);
            }
        }
        return user;
    }

    private static Map<String, String> getCasAttributes(Document document) throws IOException, SAXException {
        HashMap<String, String> casAttribut = new HashMap<String, String>();
        NodeList list = document.getElementsByTagName("cas:attributes");
        if (list.getLength() > 0) {
            Node nodeAttribute = list.item(0);
            for (int i = 0; i < nodeAttribute.getChildNodes().getLength(); ++i) {
                Node attribute = nodeAttribute.getChildNodes().item(i);
                casAttribut.put(attribute.getNodeName(), attribute.getTextContent());
            }
        }
        return casAttribut;
    }

    public static String getProxyTicket(String username, String serviceName) throws IOException, SAXException, InterruptedException, ExecutionException {
        String proxyTicket = null;
        String pgt = (String)Cache.get((String)("pgt_" + username));
        String url = CASUtils.getCasProxyUrl() + "?pgt=" + pgt + "&targetService=" + serviceName;
        Document response = WS.url((String)url).get().getXml();
        NodeList list = response.getElementsByTagName("cas:proxySuccess");
        if (list.getLength() > 0) {
            proxyTicket = response.getElementsByTagName("cas:proxyTicket").item(0).getTextContent();
        } else {
            Logger.error((String)("CAS server responded with error for request [" + url + "].  Full response was [" + response.getElementsByTagName("cas:proxyFailure").item(0).getTextContent() + "]"), (Object[])new Object[0]);
        }
        Logger.debug((String)("[SecureCAS]: PT for user " + username + " and service " + serviceName + " is " + proxyTicket), (Object[])new Object[0]);
        return proxyTicket;
    }
}

