/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cheese;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Node;
import play.modules.cheese.CreditCard;
import play.modules.cheese.CustomerProfile;
import play.modules.cheese.Item;
import play.modules.cheese.Plan;
import play.modules.cheese.Service;
import play.modules.cheese.Subscription;
import play.modules.cheese.util.XPathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Customer {
    private String code;
    private String firstName;
    private String lastName;
    private String email;
    private String company;
    private String gatewayToken;
    private List<Subscription> subscriptions = new ArrayList<Subscription>();
    private Service service;

    public Customer(Service service, Node node) {
        this.service = service;
        this.code = XPathUtil.selectText("@code", node);
        this.firstName = XPathUtil.selectText("firstName", node);
        this.lastName = XPathUtil.selectText("lastName", node);
        this.email = XPathUtil.selectText("email", node);
        this.company = XPathUtil.selectText("company", node);
        this.gatewayToken = XPathUtil.selectText("gatewayToken", node);
        this.subscriptions = XPathUtil.selectList("subscriptions/subscription", node, service, Subscription.class);
    }

    public void addCharge(String chargeCode, int quantity, BigDecimal eachAmount, String description) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chargeCode", chargeCode);
        params.put("quantity", quantity);
        params.put("eachAmount", eachAmount.toPlainString());
        params.put("description", description);
        this.service.post("/customers/add-charge/productCode/" + this.service.getProductCode() + "/code/" + this.code, params);
    }

    public void addItemUsage(Item item, BigDecimal qty) {
        this.addItemUsage(item.getCode(), qty);
    }

    public void addItemUsage(String itemCode, BigDecimal qty) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("quantity", qty.toPlainString());
        this.service.post("/customers/add-item-quantity/productCode/" + this.service.getProductCode() + "/code/" + this.code + "/itemCode/" + itemCode, params);
    }

    public void cancel() {
        this.service.get("/customers/cancel/productCode/" + this.service.getProductCode() + "/code/" + this.code);
    }

    public void deleteCharge(String chargeId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chargeId", chargeId);
        this.service.post("/customers/delete-charge/productCode/" + this.service.getProductCode() + "/code/" + this.code, params);
    }

    public List<String> getActivePlanCodes() {
        ArrayList<String> plans = new ArrayList<String>();
        for (Subscription sub : this.subscriptions) {
            if (sub.isCanceled()) continue;
            for (Plan plan : sub.getPlans()) {
                plans.add(plan.getCode());
            }
        }
        return plans;
    }

    public String getCode() {
        return this.code;
    }

    public CustomerProfile getProfile() {
        return new CustomerProfile(this);
    }

    public String getCompany() {
        return this.company;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getGatewayToken() {
        return this.gatewayToken;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Service getService() {
        return this.service;
    }

    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public boolean hasActivePlanByCode(String plan) {
        return this.getActivePlanCodes().contains(plan);
    }

    public void reduceItemUsage(Item item, BigDecimal qty) {
        this.reduceItemUsage(item.getCode(), qty);
    }

    public void reduceItemUsage(String itemCode, BigDecimal qty) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("quantity", qty.toPlainString());
        this.service.post("/customers/add-item-quantity/productCode/" + this.service.getProductCode() + "/code/" + this.code + "/itemCode/" + itemCode, params);
    }

    public void updateItemUsage(Item item, BigDecimal qty) {
        this.updateItemUsage(item.getCode(), qty);
    }

    public void updateItemUsage(String itemCode, BigDecimal qty) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("quantity", qty.toPlainString());
        this.service.post("/customers/set-item-quantity/productCode/" + this.service.getProductCode() + "/code/" + this.code + "/itemCode/" + itemCode, params);
    }

    public void subscribe(String plan, CreditCard card) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("planCode", plan);
        params.put("ccFirstName", card.getFirstName());
        params.put("ccLastName", card.getLastName());
        params.put("ccNumber", card.getNumber());
        params.put("ccExpiration", card.getExpireMonth() + "/" + card.getExpireYear());
        if (card.getCode() != null) {
            params.put("ccCardCode", card.getCode());
        }
        if (card.getZip() != null) {
            params.put("ccZip", card.getZip());
        }
        this.service.post("/customers/edit-subscription/productCode/" + this.service.getProductCode() + "/code/" + this.code, params);
    }

    public void subscribe(String plan, String ccNumber, int expireMo, int expireYear) {
        this.subscribe(plan, new CreditCard(this.firstName, this.lastName, ccNumber, expireMo, expireYear));
    }

    public void subscribe(String plan, String ccNumber, String expiration) {
        String[] expirationSplit = expiration.split("/");
        int expireMo = Integer.parseInt(expirationSplit[0]);
        int expireYear = Integer.parseInt(expirationSplit[1]);
        this.subscribe(plan, new CreditCard(this.firstName, this.lastName, ccNumber, expireMo, expireYear));
    }

    public void updateCustomer(CustomerProfile profile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("firstName", profile.getFirstName());
        params.put("lastName", profile.getLastName());
        params.put("email", profile.getEmail());
        String company = profile.getCompany();
        if (company != null) {
            params.put("company", company);
        }
        this.service.post("/customers/edit-customer/productCode/" + this.service.getProductCode() + "/code/" + this.code, params);
    }
}

