/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cheese;

import java.util.Date;
import java.util.List;
import org.w3c.dom.Node;
import play.modules.cheese.Charge;
import play.modules.cheese.Service;
import play.modules.cheese.Transaction;
import play.modules.cheese.util.XPathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoice {
    private String code;
    private String id;
    private int number;
    private String type;
    private Date billingDatetime;
    private Date createdDatetime;
    private List<Transaction> transactions;
    private List<Charge> charges;

    public Invoice(Service service, Node node) {
        this.code = XPathUtil.selectText("@code", node);
        this.id = XPathUtil.selectText("@id", node);
        this.type = XPathUtil.selectText("type", node);
        this.number = XPathUtil.selectInt("number", node);
        this.billingDatetime = XPathUtil.selectDate("billingDatetime", node);
        this.createdDatetime = XPathUtil.selectDate("createdDatetime", node);
        this.transactions = XPathUtil.selectList("transactions/transaction", node, service, Transaction.class);
        this.charges = XPathUtil.selectList("charges/charge", node, service, Charge.class);
    }

    public Date getBillingDatetime() {
        return this.billingDatetime;
    }

    public List<Charge> getCharges() {
        return this.charges;
    }

    public String getCode() {
        return this.code;
    }

    public Date getCreatedDatetime() {
        return this.createdDatetime;
    }

    public String getId() {
        return this.id;
    }

    public int getNumber() {
        return this.number;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public String getType() {
        return this.type;
    }
}

