/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cheese;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Node;
import play.modules.cheese.Item;
import play.modules.cheese.Service;
import play.modules.cheese.util.XPathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plan {
    private String code;
    private String id;
    private String name;
    private String description;
    private boolean isActive;
    private boolean isFree;
    private int trialDays;
    private int initialBillCount;
    private String initialBillCountUnit;
    private String billingFrequency;
    private String billingFrequencyPer;
    private String billingFrequencyUnit;
    private int billingFrequencyQuantity;
    private Date nextInvoiceBillingDatetime;
    private String setupChargeCode;
    private BigDecimal setupChargeAmount;
    private String recurringChargeCode;
    private BigDecimal recurringChargeAmount;
    private Date createdDatetime;
    private List<Item> items;

    public Plan(Service service, Node node) {
        this.code = XPathUtil.selectText("@code", node);
        this.id = XPathUtil.selectText("@id", node);
        this.name = XPathUtil.selectText("name", node);
        this.description = XPathUtil.selectText("description", node);
        this.isActive = XPathUtil.selectBoolean("isActive", node);
        this.isFree = XPathUtil.selectBoolean("isFree", node);
        this.trialDays = XPathUtil.selectInt("trialDays", node);
        this.initialBillCount = XPathUtil.selectInt("initialBillCount", node);
        this.initialBillCountUnit = XPathUtil.selectText("initialBillCountUnit", node);
        this.billingFrequency = XPathUtil.selectText("billingFrequency", node);
        this.billingFrequencyPer = XPathUtil.selectText("billingFrequencyPer", node);
        this.billingFrequencyUnit = XPathUtil.selectText("billingFrequencyUnit", node);
        this.billingFrequencyQuantity = XPathUtil.selectInt("billingFrequencyQuantity", node);
        this.nextInvoiceBillingDatetime = XPathUtil.selectDate("nextInvoiceBillingDatetime", node);
        this.setupChargeCode = XPathUtil.selectText("setupChargeCode", node);
        this.setupChargeAmount = XPathUtil.selectDecimal("setupChargeAmount", node);
        this.createdDatetime = XPathUtil.selectDate("createdDatetime", node);
        this.recurringChargeCode = XPathUtil.selectText("recurringChargeCode", node);
        this.recurringChargeAmount = XPathUtil.selectDecimal("recurringChargeAmount", node);
        this.items = XPathUtil.selectList("items/item", node, service, Item.class);
    }

    public String getBillingFrequency() {
        return this.billingFrequency;
    }

    public String getBillingFrequencyPer() {
        return this.billingFrequencyPer;
    }

    public int getBillingFrequencyQuantity() {
        return this.billingFrequencyQuantity;
    }

    public String getBillingFrequencyUnit() {
        return this.billingFrequencyUnit;
    }

    public String getCode() {
        return this.code;
    }

    public Date getCreatedDatetime() {
        return this.createdDatetime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public int getInitialBillCount() {
        return this.initialBillCount;
    }

    public String getInitialBillCountUnit() {
        return this.initialBillCountUnit;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public Date getNextInvoiceBillingDatetime() {
        return this.nextInvoiceBillingDatetime;
    }

    public BigDecimal getRecurringChargeAmount() {
        return this.recurringChargeAmount;
    }

    public String getRecurringChargeCode() {
        return this.recurringChargeCode;
    }

    public BigDecimal getSetupChargeAmount() {
        return this.setupChargeAmount;
    }

    public String getSetupChargeCode() {
        return this.setupChargeCode;
    }

    public int getTrialDays() {
        return this.trialDays;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isFree() {
        return this.isFree;
    }
}

