/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cheese;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import play.Play;
import play.libs.WS;
import play.libs.XPath;
import play.modules.cheese.CheddarGetterException;
import play.modules.cheese.CreditCard;
import play.modules.cheese.Customer;
import play.modules.cheese.Plan;
import play.modules.cheese.util.XPathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service {
    private String user;
    private String password;
    private String productCode;
    public static String ROOT = "https://cheddargetter.com/xml";

    public Service(String productCode) {
        this.user = (String)Play.configuration.get("cg.user");
        this.password = (String)Play.configuration.get("cg.password");
        this.productCode = productCode;
    }

    public Service(String user, String password, String productCode) {
        this.user = user;
        this.password = password;
        this.productCode = productCode;
    }

    public Customer addCustomer(String custCode, String firstName, String lastName, String email, String plan) {
        return this.addCustomer(custCode, firstName, lastName, email, plan, null);
    }

    public Customer addCustomer(String custCode, String firstName, String lastName, String email, String plan, CreditCard card) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", custCode);
        params.put("firstName", firstName);
        params.put("lastName", lastName);
        params.put("email", email);
        params.put("subscription[planCode]", plan);
        if (card != null) {
            params.put("subscription[ccFirstName]", card.getFirstName());
            params.put("subscription[ccLastName]", card.getLastName());
            params.put("subscription[ccNumber]", card.getNumber());
            params.put("subscription[ccExpiration]", card.getExpireMonth() + "/" + card.getExpireYear());
            if (card.getCode() != null) {
                params.put("subscription[ccCardCode]", card.getCode());
            }
            if (card.getZip() != null) {
                params.put("subscription[ccZip]", card.getZip());
            }
        }
        WS.HttpResponse resp = this.post("/customers/new/productCode/" + this.productCode, params);
        return new Customer(this, resp.getXml().getFirstChild());
    }

    public void deleteCustomer(String custCode) {
        this.get("/customers/delete/productCode/" + this.productCode + "/code/" + custCode);
    }

    public WS.HttpResponse get(String api) {
        WS.HttpResponse resp = WS.url((String)(ROOT + api)).authenticate(this.user, this.password).get();
        CheddarGetterException.validate(resp);
        return resp;
    }

    public Customer getCustomer(String custCode) {
        WS.HttpResponse resp = this.get("/customers/get/productCode/" + this.productCode + "/code/" + custCode);
        Customer customer = new Customer(this, XPath.selectNode((String)"/customers/customer", (Object)resp.getXml().getFirstChild()));
        return customer;
    }

    public List<Customer> getCustomers() {
        WS.HttpResponse resp = this.get("/customers/get/productCode/" + this.productCode);
        Node root = resp.getXml().getFirstChild();
        List<Customer> customers = XPathUtil.selectList("customer", root, this, Customer.class);
        return customers;
    }

    public String getPassword() {
        return this.password;
    }

    public Plan getPricingPlan(String planCode) {
        WS.HttpResponse resp = this.get("/plans/get/productCode/" + this.productCode + "/code/" + planCode);
        Plan plan = new Plan(this, XPath.selectNode((String)"/plans/plan", (Object)resp.getXml().getFirstChild()));
        return plan;
    }

    public List<Plan> getPricingPlans() {
        WS.HttpResponse resp = this.get("/plans/get/productCode/" + this.productCode);
        List<Plan> plans = XPathUtil.selectList("/plans/plan", resp.getXml().getFirstChild(), this, Plan.class);
        return plans;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getUser() {
        return this.user;
    }

    public WS.HttpResponse post(String api, Map<String, Object> params) {
        WS.HttpResponse resp = WS.url((String)(ROOT + api)).params(params).authenticate(this.user, this.password).post();
        CheddarGetterException.validate(resp);
        return resp;
    }
}

