/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cheese;

import java.util.Date;
import java.util.List;
import org.w3c.dom.Node;
import play.modules.cheese.Invoice;
import play.modules.cheese.Item;
import play.modules.cheese.Plan;
import play.modules.cheese.Service;
import play.modules.cheese.util.XPathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscription {
    private String id;
    private String ccFirstName;
    private String ccLastName;
    private String ccType;
    private String ccLastFour;
    private String ccExpirationDate;
    private List<Plan> plans;
    private List<Item> items;
    private List<Invoice> invoices;
    private boolean canceled;
    private Date canceledDateTime;

    public Subscription(Service service, Node node) {
        this.id = XPathUtil.selectText("@id", node);
        this.ccFirstName = XPathUtil.selectText("ccFirstName", node);
        this.ccLastName = XPathUtil.selectText("ccLastName", node);
        this.ccType = XPathUtil.selectText("ccType", node);
        this.ccLastFour = XPathUtil.selectText("ccLastFour", node);
        this.ccExpirationDate = XPathUtil.selectText("ccExpirationDate", node);
        this.plans = XPathUtil.selectList("plans/plan", node, service, Plan.class);
        this.items = XPathUtil.selectList("items/item", node, service, Item.class);
        this.invoices = XPathUtil.selectList("invoices/invoice", node, service, Invoice.class);
        this.canceledDateTime = XPathUtil.selectDate("canceledDatetime", node);
        this.canceled = this.canceledDateTime != null;
    }

    public Date getCanceledDateTime() {
        return this.canceledDateTime;
    }

    public String getCcExpirationDate() {
        return this.ccExpirationDate;
    }

    public String getCcFirstName() {
        return this.ccFirstName;
    }

    public String getCcLastFour() {
        return this.ccLastFour;
    }

    public String getCcLastName() {
        return this.ccLastName;
    }

    public String getCcType() {
        return this.ccType;
    }

    public String getId() {
        return this.id;
    }

    public List<Invoice> getInvoices() {
        return this.invoices;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public List<Plan> getPlans() {
        return this.plans;
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

