/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cheese.util;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;
import play.Logger;
import play.libs.XPath;
import play.modules.cheese.CheddarGetterException;
import play.modules.cheese.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathUtil {
    private static final SimpleDateFormat cgf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static boolean selectBoolean(String xpath, Node node) {
        return XPathUtil.selectBoolean(xpath, node, false);
    }

    public static boolean selectBoolean(String xpath, Node node, boolean def) {
        String val = XPathUtil.selectText(xpath, node);
        if (StringUtils.isBlank((String)val)) {
            return def;
        }
        return Boolean.parseBoolean(val);
    }

    public static Date selectDate(String xpath, Node node) {
        cgf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String val = XPathUtil.selectText(xpath, node);
        if (StringUtils.isBlank((String)val)) {
            return null;
        }
        try {
            String strippedVal = val.substring(0, 19);
            return cgf.parse(strippedVal);
        }
        catch (ParseException e) {
            Logger.fatal((Throwable)e, (String)"Error parsing date from CheddarGetter: %s", (Object[])new Object[]{val});
            return null;
        }
    }

    public static BigDecimal selectDecimal(String xpath, Node node) {
        return XPathUtil.selectDecimal(xpath, node, BigDecimal.ZERO);
    }

    public static BigDecimal selectDecimal(String xpath, Node node, BigDecimal def) {
        String val = XPathUtil.selectText(xpath, node);
        if (StringUtils.isBlank((String)val)) {
            return def;
        }
        return new BigDecimal(val);
    }

    public static float selectFloat(String xpath, Node node) {
        return XPathUtil.selectFloat(xpath, node, 0.0f);
    }

    public static float selectFloat(String xpath, Node node, float def) {
        String val = XPathUtil.selectText(xpath, node);
        if (StringUtils.isBlank((String)val)) {
            return def;
        }
        return Float.parseFloat(val);
    }

    public static int selectInt(String xpath, Node node) {
        return XPathUtil.selectInt(xpath, node, 0);
    }

    public static int selectInt(String xpath, Node node, int def) {
        String val = XPathUtil.selectText(xpath, node);
        if (StringUtils.isBlank((String)val)) {
            return def;
        }
        return Integer.parseInt(val);
    }

    public static <T> List<T> selectList(String xpath, Node node, Service service, Class<T> typeToken) {
        List foundNodes = XPath.selectNodes((String)xpath, (Object)node);
        ArrayList<T> list = new ArrayList<T>();
        for (Node foundNode : foundNodes) {
            try {
                list.add(typeToken.getConstructor(Service.class, Node.class).newInstance(service, foundNode));
            }
            catch (IllegalArgumentException e) {
                throw new CheddarGetterException("Error reading response xml", e);
            }
            catch (SecurityException e) {
                throw new CheddarGetterException("Error reading response xml", e);
            }
            catch (InstantiationException e) {
                throw new CheddarGetterException("Error reading response xml", e);
            }
            catch (IllegalAccessException e) {
                throw new CheddarGetterException("Error reading response xml", e);
            }
            catch (InvocationTargetException e) {
                throw new CheddarGetterException("Error reading response xml", e);
            }
            catch (NoSuchMethodException e) {
                throw new CheddarGetterException("Error reading response xml", e);
            }
        }
        return list;
    }

    public static String selectText(String xpath, Node node) {
        return XPathUtil.selectText(xpath, node, "");
    }

    public static String selectText(String xpath, Node node, String def) {
        String val = XPath.selectText((String)xpath, (Object)node);
        if (val == null) {
            return def;
        }
        return val;
    }
}

