/*
 * Decompiled with CFR 0.152.
 */
package net.stax.log;

import java.util.Map;
import net.stax.log.ILogQueue;
import net.stax.log.LogEntry;
import net.stax.log.LogQueue;
import net.stax.log.StaxLogging;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class Log4JAppender
extends AppenderSkeleton {
    private ILogQueue queue;
    private String license;
    private String sourceName;
    private String baseUrl;
    private boolean mdcEnabled = false;
    private boolean initedStaxLogging = false;

    public void activateOptions() {
        super.activateOptions();
        if (!StaxLogging.isInitialized()) {
            StaxLogging.init(this.baseUrl, this.license, this.sourceName);
            this.initedStaxLogging = true;
        }
        if (this.queue == null) {
            this.queue = LogQueue.instance();
        }
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setMdcEnabled(boolean enabled) {
        this.mdcEnabled = enabled;
    }

    protected void append(LoggingEvent evt) {
        try {
            String message = evt.getRenderedMessage();
            int level = this.getLevel(evt.getLevel());
            String category = evt.getLoggerName();
            long date = evt.timeStamp;
            String threadName = evt.getThreadName();
            Throwable th = null;
            ThrowableInformation thInfo = evt.getThrowableInformation();
            if (thInfo != null) {
                th = thInfo.getThrowable();
            }
            Map properties = null;
            if (this.mdcEnabled) {
                try {
                    properties = evt.getProperties();
                }
                catch (Throwable error) {
                    error.printStackTrace();
                    this.mdcEnabled = false;
                }
            }
            LogEntry entry = new LogEntry(message, level, category, date, threadName, th, properties);
            this.queue.add(entry);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getLevel(Level level) {
        if (level.equals((Object)Level.ALL)) {
            return 0;
        }
        if (level.equals((Object)Level.TRACE)) {
            return 5000;
        }
        if (level.equals((Object)Level.DEBUG)) {
            return 10000;
        }
        if (level.equals((Object)Level.INFO)) {
            return 20000;
        }
        if (level.equals((Object)Level.WARN)) {
            return 30000;
        }
        if (level.equals((Object)Level.ERROR)) {
            return 40000;
        }
        if (level.equals((Object)Level.FATAL)) {
            return 50000;
        }
        if (level.equals((Object)Level.OFF)) {
            return 10000000;
        }
        return 10000;
    }

    public void close() {
        if (this.initedStaxLogging) {
            StaxLogging.stop();
        }
    }

    public boolean requiresLayout() {
        return false;
    }
}

