/*
 * Decompiled with CFR 0.152.
 */
package net.stax.log;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import net.stax.log.ILogClient;
import net.stax.log.LogEntry;
import net.stax.log.LogQuery;
import net.stax.log.json.JSONArray;
import net.stax.log.json.JSONException;
import net.stax.log.json.JSONObject;
import net.stax.log.json.JSONTokener;

public class LogClient
implements ILogClient {
    private String baseURL;
    private String license;
    private String source;
    private String host;
    private String process;

    public LogClient(String baseUrl, String license, String source, String host, String process) {
        this.baseURL = baseUrl;
        this.license = license;
        this.source = source;
        this.host = host;
        this.process = process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEntries(LogEntry ... entries) throws Exception {
        block8: {
            String urlString = String.format("%slog?license=%s&version=1", this.baseURL, this.license);
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            try {
                conn.setDoOutput(true);
                String jsonText = this.createLogEntries(this.license, this.source, entries).toString();
                OutputStream out = conn.getOutputStream();
                try {
                    out.write(jsonText.getBytes("utf-8"));
                }
                finally {
                    out.close();
                }
                int returnCode = conn.getResponseCode();
                if (returnCode == 200) {
                    break block8;
                }
                throw new Exception("Unexpected error code: " + returnCode);
            }
            finally {
                conn.disconnect();
            }
        }
    }

    private String readAll(InputStream in) throws IOException {
        StringWriter sw = new StringWriter();
        InputStreamReader r = new InputStreamReader(in);
        char[] buf = new char[1024];
        int numRead = r.read(buf);
        while (numRead != -1) {
            sw.write(buf, 0, numRead);
            numRead = r.read(buf);
        }
        return sw.toString();
    }

    public JSONArray getLogEntries(LogQuery query) throws Exception {
        StringBuffer sb = new StringBuffer();
        this.addQueryParam("category", query.getCategory(), null, sb);
        this.addQueryParam("host", query.getHost(), null, sb);
        this.addQueryParam("level", query.getLevel(), null, sb);
        this.addQueryParam("message", query.getMessage(), null, sb);
        this.addQueryParam("process", query.getProcess(), null, sb);
        this.addQueryParam("thread", query.getThread(), null, sb);
        this.addQueryParam("beforeId", query.getEndBeforeId(), -1, sb);
        this.addQueryParam("afterId", query.getStartAfterId(), -1, sb);
        this.addQueryParam("limit", query.getMaxResults(), -1, sb);
        String queryString = sb.toString();
        String urlString = String.format("%slog?license=%s&source=%s&format=json&%s", this.baseURL, this.license, this.source, queryString);
        return this.getResults(urlString);
    }

    private void addQueryParam(String name, Object value, Object defaultValue, StringBuffer sb) {
        if (value != defaultValue && !value.equals(defaultValue)) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            try {
                sb.append(URLEncoder.encode(name, "utf-8"));
                sb.append("=");
                sb.append(URLEncoder.encode(value.toString(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray getResults(String urlString) throws Exception {
        System.out.println("getResults: " + urlString);
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            int returnCode = conn.getResponseCode();
            if (returnCode == 200) {
                InputStream input = conn.getInputStream();
                try {
                    JSONArray json;
                    InputStreamReader reader = new InputStreamReader(input);
                    JSONArray jSONArray = json = new JSONArray(new JSONTokener(reader));
                    return jSONArray;
                }
                finally {
                    input.close();
                }
            }
            throw new Exception("Unexpected error code: " + returnCode);
        }
        finally {
            conn.disconnect();
        }
    }

    private JSONObject createLogEntries(String license, String srcKey, LogEntry ... entries) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("source", srcKey);
        object.put("host", this.host);
        object.put("process", this.process);
        JSONArray array = new JSONArray();
        for (LogEntry entry : entries) {
            JSONObject jsonEntry = new JSONObject();
            if (entry.properties != null) {
                for (Map.Entry<String, Object> nvpair : entry.properties.entrySet()) {
                    Object val = nvpair.getValue();
                    if (val == null || !(val instanceof String) && !(val instanceof Number) && !(val instanceof Boolean)) continue;
                    jsonEntry.put(nvpair.getKey().toString(), nvpair.getValue().toString());
                }
            }
            jsonEntry.put("message", entry.message);
            jsonEntry.put("level", entry.level);
            jsonEntry.put("category", entry.category);
            jsonEntry.put("time", entry.date);
            jsonEntry.put("thread", entry.thread);
            if (entry.details != null) {
                if (entry.details instanceof Throwable) {
                    Throwable th = (Throwable)entry.details;
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    th.printStackTrace(pw);
                    pw.close();
                    String value = sw.toString();
                    jsonEntry.put("exception", value);
                } else {
                    jsonEntry.put("details", entry.details.toString());
                }
            }
            array.put(jsonEntry);
        }
        object.put("entries", array);
        return object;
    }
}

