/*
 * Decompiled with CFR 0.152.
 */
package net.stax.log;

import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;
import net.stax.log.ILogClient;
import net.stax.log.LogEntry;
import net.stax.log.LogQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogWorker
implements Runnable {
    private static final int MAX_BACKLOG = 1000;
    private ILogClient client;
    private LinkedList<Queue<LogEntry>> backlog = new LinkedList();
    private LogQueue logQueue;
    private int backlogSize;
    private boolean running = false;
    private Object sleepLock = new Object();

    public LogWorker(ILogClient client, LogQueue queue) {
        this.client = client;
        this.logQueue = queue;
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            this.processEntries();
        }
        System.out.println("LogWorker stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        Object object = this.sleepLock;
        synchronized (object) {
            this.sleepLock.notifyAll();
        }
    }

    synchronized void processEntries() {
        try {
            if (this.consumeBacklog()) {
                this.consumeLogEntries();
                if (this.logQueue.isEmpty()) {
                    this.sleep(1000L);
                }
            } else {
                this.addToBackLog(this.logQueue.consume());
                this.sleep(1000L);
            }
        }
        catch (Exception e) {
            this.sleep(10000L);
        }
    }

    public int getBackLogSize() {
        return this.backlogSize;
    }

    private boolean consumeBacklog() {
        while (!this.backlog.isEmpty()) {
            Queue<LogEntry> queue = this.backlog.getFirst();
            try {
                int size = queue.size();
                this.client.sendEntries(queue.toArray(new LogEntry[0]));
                this.backlog.removeFirst();
                this.backlogSize -= size;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private boolean consumeLogEntries() {
        Queue<LogEntry> queue = this.logQueue.consume();
        if (!queue.isEmpty()) {
            try {
                this.client.sendEntries(queue.toArray(new LogEntry[0]));
                return true;
            }
            catch (Exception e) {
                System.out.println(String.format("Adding %s to log backlog", queue.size()));
                this.addToBackLog(queue);
                return false;
            }
        }
        return true;
    }

    private void addToBackLog(Queue<LogEntry> queue) {
        this.backlogSize += queue.size();
        this.backlog.add(queue);
        this.purgeBacklog();
    }

    private void purgeBacklog() {
        while (this.backlogSize > 1000) {
            Queue<LogEntry> queue = this.backlog.peek();
            while (this.backlogSize > 1000 && !queue.isEmpty()) {
                LogEntry entry = queue.remove();
                --this.backlogSize;
                String dateStr = DateFormat.getDateTimeInstance().format(new Date(entry.date));
                System.out.println(String.format("%s [%s] %s %s %s", dateStr, entry.thread, entry.level, entry.category, entry.message));
            }
            if (!queue.isEmpty()) continue;
            this.backlog.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(long time) {
        Object object = this.sleepLock;
        synchronized (object) {
            try {
                this.sleepLock.wait(time);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }
}

