/*
 * Decompiled with CFR 0.152.
 */
package net.stax.log;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.stax.log.ILogQueue;
import net.stax.log.LogEntry;
import net.stax.log.LogQueue;

public class LoggingHandler
extends Handler {
    private ILogQueue queue = LogQueue.instance();

    public void close() throws SecurityException {
    }

    public void flush() {
    }

    public void publish(LogRecord record) {
        String message = record.getMessage();
        int level = this.getLevel(record.getLevel());
        String category = record.getLoggerName();
        long date = record.getMillis();
        String threadName = "thread-" + record.getThreadID();
        Throwable th = record.getThrown();
        LogEntry entry = new LogEntry(message, level, category, date, threadName, th, null);
        this.queue.add(entry);
    }

    private int getLevel(Level level) {
        if (level == Level.ALL) {
            return 0;
        }
        if (level == Level.FINEST) {
            return 1000;
        }
        if (level == Level.FINER) {
            return 2000;
        }
        if (level == Level.FINE) {
            return 5000;
        }
        if (level == Level.CONFIG) {
            return 15000;
        }
        if (level == Level.INFO) {
            return 20000;
        }
        if (level == Level.WARNING) {
            return 30000;
        }
        if (level == Level.SEVERE) {
            return 40000;
        }
        if (level == Level.OFF) {
            return 10000000;
        }
        return 10000;
    }
}

