/*
 * Decompiled with CFR 0.152.
 */
package net.stax.log;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import net.stax.log.ILogDriver;
import net.stax.log.LogClient;
import net.stax.log.LogQueue;
import net.stax.log.LogWorker;

public class StaxLogging {
    public static final String DEFAULT_BASE_URL = "http://log.stax.net/";
    private static boolean inited = false;
    private static String license;
    private static String sourceName;
    private static String baseURL;
    private static LogWorker worker;
    private static List<ILogDriver> drivers;
    private static Logger logger;

    public static void init(String baseURL, String license, String sourceName) {
        if (baseURL == null) {
            baseURL = DEFAULT_BASE_URL;
        }
        StaxLogging.baseURL = baseURL;
        StaxLogging.license = license;
        StaxLogging.sourceName = sourceName;
        if (license == null) {
            System.err.println("Missing stax logging license");
        }
        if (sourceName == null) {
            System.err.println("Missing stax logging sourceName");
        }
        if (!inited) {
            inited = true;
            StaxLogging.startLogClient(baseURL, license, sourceName);
            StaxLogging.initJavaLogging();
            System.out.println(String.format("Stax logging initialized [source=%s]", sourceName));
        } else {
            if (!StaxLogging.baseURL.equals(baseURL)) {
                System.err.println("Stax logging has already been initialized, additional baseURL ignored: " + baseURL);
            }
            if (!StaxLogging.license.equals(license)) {
                System.err.println("Stax logging has already been initialized, additional license ignored: " + license);
            }
            if (!StaxLogging.sourceName.equals(sourceName)) {
                System.err.println("Stax logging has already been initialized, additional sourceName ignored: " + sourceName);
            }
        }
    }

    private static void initJavaLogging() {
        StaxLogging.loadLogDriver("net.stax.log.JavaLoggingDriver", StaxLogging.class.getClassLoader());
    }

    public static void stop() {
        StaxLogging.stopDrivers();
        if (worker != null) {
            worker.stop();
        }
        worker = null;
        inited = false;
        license = null;
        sourceName = null;
        baseURL = null;
        System.out.println("Stax logging stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopDrivers() {
        ILogDriver[] driverArray;
        List<ILogDriver> list = drivers;
        synchronized (list) {
            driverArray = drivers.toArray(new ILogDriver[0]);
            drivers.clear();
        }
        for (ILogDriver driver : driverArray) {
            try {
                driver.destroy();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static boolean isInitialized() {
        return inited;
    }

    private static void startLogClient(String baseURL, String license, String sourceName) {
        LogClient client = new LogClient(baseURL, license, sourceName, StaxLogging.getHostName(), ManagementFactory.getRuntimeMXBean().getName());
        worker = new LogWorker(client, LogQueue.instance());
        Thread th = new Thread((Runnable)worker, "StaxLogWorker");
        th.setDaemon(true);
        th.start();
    }

    private static String getHostName() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            return address.getHostName();
        }
        catch (Exception e) {
            return "unknownhost-" + new Random().nextInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLogDriver(String className, ClassLoader cl) {
        List<ILogDriver> list = drivers;
        synchronized (list) {
            try {
                Class<?> cls = cl.loadClass(className);
                StaxLogging.loadLogDriver(cls);
            }
            catch (Exception e) {
                logger.info("Logger driver is not loaded: " + className);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLogDriver(Class cls) {
        List<ILogDriver> list = drivers;
        synchronized (list) {
            try {
                ILogDriver driver = (ILogDriver)cls.newInstance();
                driver.init(LogQueue.instance());
                logger.info("Logger driver loaded: " + cls.getName());
                drivers.add(driver);
            }
            catch (Exception e) {
                logger.info("Logger driver is not loaded: " + cls.getName());
            }
        }
    }

    static {
        drivers = new ArrayList<ILogDriver>();
        logger = Logger.getLogger(StaxLogging.class.getName());
    }
}

