/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk;

import com.cloudbees.sdk.commands.Command;
import com.cloudbees.sdk.utils.Helper;
import com.staxnet.appserver.utils.XmlHelper;
import com.staxnet.repository.LocalRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Bees {
    public static String version = "0.6.0";
    private static String app_template_xml_url = "http://cloudbees-downloads.s3.amazonaws.com/";
    private static String app_template_xml_name = "sdk/cloudbees-sdk-config-0-6-0.xml";
    private static String app_template_xml_desc = "CloudBees SDK configuration";
    private static String help_file_name = "conf/beesHelp.txt";
    private static String command_file_name = "conf/beesCommands.properties";
    private static final String CMD_NAME = "bees";
    private HashMap<String, Command> commands = new HashMap();

    public Bees() {
        if (!this.initialize(version)) {
            throw new RuntimeException("");
        }
        Properties cmdProperties = new Properties();
        Helper.loadProperties(new File(this.getHome(), command_file_name), cmdProperties);
        for (Object key : cmdProperties.keySet()) {
            Command command;
            String cmdName = cmdProperties.getProperty((String)key);
            List<String> parameters = this.getCommandParameters((String)key);
            String cmdClassName = parameters.get(0);
            if (parameters.size() > 1) {
                String[] params = new String[parameters.size() - 1];
                for (int i = 1; i < parameters.size(); ++i) {
                    params[i - 1] = parameters.get(i);
                }
                command = this.getCommand(cmdClassName, params);
            } else {
                command = this.getCommand(cmdClassName, null);
            }
            if (command == null) continue;
            this.commands.put(cmdName, command);
        }
    }

    public void run(String[] args) {
        if (args.length < 1) {
            this.printHelp();
            System.exit(2);
        }
        boolean help = false;
        if (args[0].equalsIgnoreCase("help")) {
            Command command;
            help = true;
            if (args.length > 1 && (command = this.initCommand(args, 1)) != null) {
                help = false;
                command.printHelp();
            }
        } else if (args.length > 0) {
            Command command = this.initCommand(args, 0);
            if (command != null) {
                command.run();
            } else {
                help = true;
            }
        } else {
            help = true;
        }
        if (help) {
            this.printHelp();
            System.exit(2);
        }
    }

    private String getHome() {
        return System.getProperty("bees.home");
    }

    private List<String> getCommandParameters(String str) {
        ArrayList<String> parameters = new ArrayList<String>();
        int i1 = str.indexOf(40);
        int i2 = str.indexOf(41);
        if (i1 > -1 && i2 > -1) {
            String[] ps;
            parameters.add(str.substring(0, i1));
            String p = str.substring(i1 + 1, i2);
            for (String p1 : ps = p.split(",")) {
                parameters.add(p1.trim());
            }
        } else {
            parameters.add(str);
        }
        return parameters;
    }

    private Command getCommand(String className, String[] parameters) {
        Command command = null;
        try {
            Class<?> cl = Class.forName(className);
            if (parameters != null) {
                Class[] types = new Class[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    types[i] = String.class;
                }
                Constructor<?> constructor = cl.getConstructor(types);
                command = (Command)constructor.newInstance(parameters);
            } else {
                Constructor<?> constructor = cl.getConstructor(null);
                command = (Command)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            System.err.println("cannot initialize command: " + className);
            e.printStackTrace();
        }
        return command;
    }

    private boolean initialize(String version) {
        boolean ok = true;
        LocalRepository localRepository = new LocalRepository();
        try {
            NamedNodeMap nodeMap;
            Node node;
            int i;
            File sdkConfig = localRepository.getURLAsFile(app_template_xml_url + app_template_xml_name, app_template_xml_name, app_template_xml_desc);
            Document doc = XmlHelper.readXMLFromFile((String)sdkConfig.getCanonicalPath());
            Element e = doc.getDocumentElement();
            String availVersion = e.getAttribute("version");
            String minVersion = e.getAttribute("min-version");
            float currentVersion = Bees.getVersion(version);
            float availableVersion = Bees.getVersion(availVersion);
            float minimunVersion = Bees.getVersion(minVersion);
            if (currentVersion < availableVersion) {
                System.out.println();
                if (currentVersion < minimunVersion) {
                    System.err.println("Error - This version of the CloudBees SDK is no longer supported, please install the latest version (" + availVersion + ").");
                    ok = false;
                } else if (currentVersion < availableVersion) {
                    System.out.println("A new version of the CloudBees SDK is available, please install the latest version (" + availVersion + ").");
                }
                String hRef = e.getAttribute("href");
                String homeRef = "www.cloudbees.com";
                NodeList nodeList = e.getElementsByTagName("link");
                for (i = 0; i < nodeList.getLength(); ++i) {
                    node = nodeList.item(i);
                    nodeMap = node.getAttributes();
                    Node rel = nodeMap.getNamedItem("rel");
                    Node href = nodeMap.getNamedItem("href");
                    if (rel == null || !rel.getTextContent().trim().equalsIgnoreCase("alternate") || href == null) continue;
                    homeRef = href.getTextContent();
                }
                System.out.println("  SDK home:     " + homeRef);
                System.out.println("  SDK download: " + hRef);
                System.out.println();
            }
            if (ok) {
                NodeList libsNL = e.getElementsByTagName("libraries");
                Node libsNode = null;
                if (libsNL.getLength() > 0) {
                    libsNode = libsNL.item(0);
                }
                if (libsNode != null) {
                    NodeList libNL = e.getElementsByTagName("library");
                    for (i = 0; i < libNL.getLength(); ++i) {
                        node = libNL.item(i);
                        nodeMap = node.getAttributes();
                        Node nameNode = nodeMap.getNamedItem("name");
                        Node refNode = nodeMap.getNamedItem("href");
                        if (nameNode == null || refNode == null) continue;
                        String libName = nameNode.getTextContent();
                        String libUrlString = refNode.getTextContent().trim();
                        int idx = libUrlString.lastIndexOf(47);
                        String libFileName = libUrlString.substring(idx);
                        localRepository.getURLAsFile(libUrlString, "lib" + libFileName, libName);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Cannot retrieve SDK version info: " + e.getMessage());
        }
        return ok;
    }

    private static float getVersion(String version) {
        String[] numbers = version.split("\\.");
        return Float.parseFloat(numbers[0]) + Float.parseFloat(numbers[1]) / 100.0f + Float.parseFloat(numbers[2]) / 10000.0f;
    }

    private Command initCommand(String[] args, int startIdx) {
        if (args.length > startIdx) {
            String[] args2 = Arrays.copyOfRange(args, startIdx + 1, args.length);
            Command command = this.commands.get(args[startIdx]);
            if (command != null) {
                command.init("bees " + args[startIdx], args2);
                return command;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printHelp() {
        BufferedReader reader = null;
        try {
            String line;
            FileReader fileReader = new FileReader(new File(this.getHome(), help_file_name));
            reader = new BufferedReader(fileReader);
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException ex) {
            System.err.println("Cannot find help file: " + help_file_name);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("CloudBees SDK version: " + version);
        try {
            new Bees().run(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
    }
}

