/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.commands;

import com.cloudbees.sdk.commands.Command;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.cli.Options;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntTarget
extends Command {
    private String target;
    private Properties antProperties = new Properties();
    protected String baseDir;

    public AntTarget(String target) {
        this.target = target;
        this.setAddCredentialsOptions(false);
    }

    protected void addAntProperty(String name, String value) {
        this.antProperties.setProperty(name, value);
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getBaseDir() {
        return this.baseDir == null ? "." : this.baseDir;
    }

    @Override
    protected String getUsageMessage() {
        return "";
    }

    @Override
    protected boolean preParseCommandLine() {
        Options options = this.getOptions();
        options.addOption("b", "baseDir", true, "Base directory (default: '.')");
        return true;
    }

    @Override
    protected boolean postParseCommandLine() {
        return true;
    }

    @Override
    protected boolean execute() {
        try {
            String value;
            String key;
            File buildFile = new File(this.baseDir, "build.xml");
            Project p = new Project();
            p.setUserProperty("ant.file", buildFile.getAbsolutePath());
            DefaultLogger consoleLogger = new DefaultLogger();
            consoleLogger.setErrorPrintStream(System.err);
            consoleLogger.setOutputPrintStream(System.out);
            consoleLogger.setMessageOutputLevel(2);
            p.addBuildListener((BuildListener)consoleLogger);
            p.init();
            Properties configProperties = this.getConfigProperties();
            Enumeration<Object> e = configProperties.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = configProperties.getProperty(key);
                p.setUserProperty("beesConfig." + key, value);
            }
            e = this.antProperties.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = this.antProperties.getProperty(key);
                p.setUserProperty(key, value);
            }
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            p.addReference("ant.projectHelper", (Object)helper);
            helper.parse(p, (Object)buildFile);
            p.executeTarget(this.target);
        }
        catch (Exception e) {
            throw new RuntimeException("Call failure: " + e.getMessage(), e);
        }
        return true;
    }
}

