/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.commands;

import com.cloudbees.sdk.commands.Command;
import com.cloudbees.sdk.utils.Helper;
import com.staxnet.ant.ApplicationHelper;
import com.staxnet.appserver.config.AppConfig;
import com.staxnet.appserver.utils.StringHelper;
import com.staxnet.appserver.utils.ZipHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipOutputStream;
import net.stax.api.ApplicationDeployArchiveResponse;
import net.stax.api.HashWriteProgress;
import net.stax.api.StaxClient;
import net.stax.api.UploadProgress;
import org.apache.commons.cli.Options;

public class ApplicationDeploy
extends Command {
    private String appid;
    private String environment;
    private String message;
    private File appConfig;
    private File appxml;
    private String baseDir;
    private File warFile;
    private File deployFile;
    private String delta;
    private String descriptorDir;

    @Override
    protected String getUsageMessage() {
        return "[Options] WAR_file [EAR_file]";
    }

    @Override
    protected boolean preParseCommandLine() {
        Options options = this.getOptions();
        options.addOption("a", "appid", true, "CloudBees application ID");
        options.addOption("m", "message", true, "Message describing the deployment");
        options.addOption("e", "environment", true, "Environment configurations to deploy");
        options.addOption("d", "delta", true, "true to enable, false to disable delta upload (default: true)");
        options.addOption("b", "baseDir", true, "Base directory (default: '.')");
        options.addOption("xd", "descriptorDir", true, "Directory containing application descriptors (default 'src/main/conf/')");
        return true;
    }

    @Override
    protected boolean postParseCommandLine() {
        boolean ok = true;
        List otherArgs = this.getCommandLine().getArgList();
        if (otherArgs.size() > 0) {
            this.setWarFile(new File(this.getBaseDir(), (String)otherArgs.get(0)));
        }
        if (otherArgs.size() > 1) {
            this.setDeployFile(new File(this.getBaseDir(), (String)otherArgs.get(1)));
        }
        if (otherArgs.size() == 0 || this.warFile == null) {
            ok = false;
        }
        return ok;
    }

    @Override
    protected void initDefaults(Properties properties) {
        super.initDefaults(properties);
        this.setAppxml(new File(this.getDescriptorDir(), "application.xml"));
        this.setAppConfig(new File(this.getDescriptorDir(), "stax-application.xml"));
    }

    protected void setAppConfig(File appConfig) {
        this.appConfig = appConfig;
    }

    protected void setAppxml(File appxml) {
        this.appxml = appxml;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    protected void setWarFile(File warFile) {
        this.warFile = warFile;
    }

    protected void setDeployFile(File deployFile) {
        this.deployFile = deployFile;
    }

    public String getDescriptorDir() {
        return this.descriptorDir == null ? "src/main/conf" : this.descriptorDir;
    }

    public void setDescriptorDir(String descriptorDir) {
        this.descriptorDir = descriptorDir;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setDelta(String delta) {
        this.delta = delta;
    }

    @Override
    protected boolean execute() {
        if (this.appConfig.exists() && this.appxml.exists()) {
            FileOutputStream fstream = null;
            try {
                fstream = new FileOutputStream(this.deployFile);
                ZipOutputStream zos = new ZipOutputStream(fstream);
                ZipHelper.addFileToZip((File)this.warFile, (String)"webapp.war", (ZipOutputStream)zos);
                ZipHelper.addFileToZip((File)this.appConfig, (String)"META-INF/stax-application.xml", (ZipOutputStream)zos);
                ZipHelper.addFileToZip((File)this.appxml, (String)"META-INF/application.xml", (ZipOutputStream)zos);
                zos.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Package failure: " + e.getMessage(), e);
            }
        } else {
            this.deployFile = this.warFile;
        }
        try {
            AppConfig appConfig = Helper.getAppConfig(this.deployFile, ApplicationHelper.getEnvironmentList(this.environment, new String[0]), new String[]{"deploy"});
            this.initAppId(appConfig);
            String defaultAppDomain = this.getConfigProperties().getProperty("bees.project.app.domain");
            String[] appIdParts = this.appid.split("/");
            String domain = null;
            if (appIdParts.length > 1) {
                domain = appIdParts[0];
            } else if (defaultAppDomain != null && !defaultAppDomain.equals("")) {
                domain = defaultAppDomain;
                this.appid = domain + "/" + this.appid;
            } else {
                throw new RuntimeException("default app domain could not be determined, appid needs to be fully-qualified ");
            }
            this.environment = StringHelper.join((String[])appConfig.getAppliedEnvironments().toArray(new String[0]), (String)",");
            System.out.println(String.format("Deploying application %s (environment: %s): %s", this.appid, this.environment, this.deployFile));
            StaxClient client = this.getStaxClient();
            boolean deployDelta = this.delta == null || this.delta.equalsIgnoreCase("true");
            ApplicationDeployArchiveResponse res = this.deployFile.getName().endsWith(".war") ? client.applicationDeployWar(this.appid, this.environment, this.message, this.deployFile.getAbsolutePath(), null, deployDelta, (UploadProgress)new HashWriteProgress()) : client.applicationDeployEar(this.appid, this.environment, this.message, this.deployFile.getAbsolutePath(), null, (UploadProgress)new HashWriteProgress());
            System.out.println("Application " + res.getId() + " deployed: " + res.getUrl());
        }
        catch (Exception e) {
            throw new RuntimeException("Application Deployment failure: " + e.getMessage(), e);
        }
        return true;
    }

    private void initAppId(AppConfig appConfig) throws IOException {
        if (this.appid == null || this.appid.equals("")) {
            this.appid = appConfig.getApplicationId();
            if (this.appid == null || this.appid.equals("")) {
                this.appid = Helper.promptForAppId();
            }
            if (this.appid == null || this.appid.equals("")) {
                throw new IllegalArgumentException("No application id specified");
            }
        }
    }
}

