/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.commands;

import com.cloudbees.sdk.commands.Command;
import com.cloudbees.sdk.utils.Helper;
import java.io.IOException;
import net.stax.api.StaxClient;
import org.apache.commons.cli.Options;

public class ApplicationInfo
extends Command {
    private String appid;

    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    protected String getUsageMessage() {
        return "[Options]";
    }

    @Override
    protected boolean preParseCommandLine() {
        Options options = this.getOptions();
        options.addOption("a", "appid", true, "CloudBees application ID");
        return true;
    }

    @Override
    protected boolean postParseCommandLine() {
        boolean ok = true;
        return ok;
    }

    @Override
    protected boolean execute() {
        try {
            this.initAppId();
            String defaultAppDomain = this.getConfigProperties().getProperty("bees.project.app.domain");
            String[] appIdParts = this.appid.split("/");
            String domain = null;
            if (appIdParts.length > 1) {
                domain = appIdParts[0];
            } else if (defaultAppDomain != null && !defaultAppDomain.equals("")) {
                domain = defaultAppDomain;
                this.appid = domain + "/" + this.appid;
            } else {
                throw new RuntimeException("default app domain could not be determined, appid needs to be fully-qualified ");
            }
            StaxClient client = this.getStaxClient();
            net.stax.api.ApplicationInfo res = client.applicationInfo(this.appid);
            System.out.println(res.getId());
            System.out.println(res.getStatus());
            System.out.println(res.getUrls()[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Application Info failure: " + e.getMessage(), e);
        }
        return true;
    }

    private void initAppId() throws IOException {
        if (this.appid == null || this.appid.equals("")) {
            this.appid = Helper.promptForAppId();
        }
        if (this.appid == null || this.appid.equals("")) {
            throw new IllegalArgumentException("No application id specified");
        }
    }
}

