/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.commands;

import com.cloudbees.sdk.commands.Command;
import com.cloudbees.sdk.utils.Helper;
import java.io.IOException;
import net.stax.api.ApplicationRestartResponse;
import net.stax.api.StaxClient;
import org.apache.commons.cli.Options;

public class ApplicationRestart
extends Command {
    private String appid;
    private Boolean force;

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    @Override
    protected String getUsageMessage() {
        return "[Options]";
    }

    @Override
    protected boolean preParseCommandLine() {
        Options options = this.getOptions();
        options.addOption("a", "appid", true, "CloudBees application ID");
        options.addOption("f", "force", false, "forced restart without prompting");
        return true;
    }

    @Override
    protected boolean postParseCommandLine() {
        boolean ok = true;
        return ok;
    }

    @Override
    protected boolean execute() {
        try {
            StaxClient client;
            ApplicationRestartResponse res;
            this.initAppId();
            String defaultAppDomain = this.getConfigProperties().getProperty("bees.project.app.domain");
            String[] appIdParts = this.appid.split("/");
            String domain = null;
            if (appIdParts.length > 1) {
                domain = appIdParts[0];
            } else if (defaultAppDomain != null && !defaultAppDomain.equals("")) {
                domain = defaultAppDomain;
                this.appid = domain + "/" + this.appid;
            } else {
                throw new RuntimeException("default app domain could not be determined, appid needs to be fully-qualified ");
            }
            if (this.force == null || !this.force.booleanValue()) {
                String in = Helper.promptFor("Are you sure you want to restart this application [" + this.appid + "]: (y/n) ");
                if (in != null) {
                    in = in.trim().toLowerCase();
                }
                if (in == null || in.startsWith("n")) {
                    return true;
                }
            }
            if ((res = (client = this.getStaxClient()).applicationRestart(this.appid)).isRestarted()) {
                System.out.println("application restarted - " + this.appid);
            } else {
                System.out.println("application could not be restarted");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Application Restart failure: " + e.getMessage(), e);
        }
        return true;
    }

    private void initAppId() throws IOException {
        if (this.appid == null || this.appid.equals("")) {
            this.appid = Helper.promptForAppId();
        }
        if (this.appid == null || this.appid.equals("")) {
            throw new IllegalArgumentException("No application id specified");
        }
    }
}

