/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.commands;

import com.cloudbees.sdk.commands.Command;
import com.cloudbees.sdk.utils.Helper;
import com.cloudbees.utils.ZipHelper;
import com.staxnet.ant.ApplicationHelper;
import com.staxnet.appserver.IAppServerConfiguration;
import com.staxnet.appserver.StaxSdkAppServer;
import com.staxnet.appserver.WarBasedServerConfiguration;
import com.staxnet.appserver.config.AppConfig;
import com.staxnet.appserver.config.AppConfigHelper;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.cli.Options;

public class ApplicationRun
extends Command {
    private String environment;
    private File appConfig;
    private String tmpDir;
    private String port;
    private String descriptorDir;
    private File warFile;
    boolean cleanWebRoot = false;
    File webRoot = null;

    @Override
    protected String getUsageMessage() {
        return "[Options] WAR_Filename | WAR_directory";
    }

    @Override
    protected boolean preParseCommandLine() {
        Options options = this.getOptions();
        options.addOption("p", "port", true, "server listen port (default: 8080)");
        options.addOption("e", "environment", true, "Environment configurations to run");
        options.addOption("t", "tmpDir", true, "Local working directory where temp files can be created (default: 'temp')");
        options.addOption("xd", "descriptorDir", true, "Directory containing application descriptors (default: 'conf')");
        return true;
    }

    @Override
    protected boolean postParseCommandLine() {
        boolean ok = true;
        List otherArgs = this.getCommandLine().getArgList();
        if (otherArgs.size() > 0) {
            this.setWarFile(new File((String)otherArgs.get(0)));
        } else {
            ok = false;
        }
        return ok;
    }

    @Override
    protected void initDefaults(Properties properties) {
        super.initDefaults(properties);
        this.setAppConfig(new File(this.getDescriptorDir(), "stax-application.xml"));
    }

    protected void setAppConfig(File appConfig) {
        this.appConfig = appConfig;
    }

    protected File getWebroot() {
        return new File(this.getTmpDir(), "webapp");
    }

    protected File getWorkDir() {
        return new File(this.getTmpDir(), "workdir");
    }

    public void setTmpDir(String tmpDir) {
        this.tmpDir = tmpDir;
    }

    protected void setWarFile(File warFile) {
        this.warFile = warFile;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setDescriptorDir(String descriptorDir) {
        this.descriptorDir = descriptorDir;
    }

    public String getTmpDir() {
        return this.tmpDir == null ? "tmp" : this.tmpDir;
    }

    public String getDescriptorDir() {
        return this.descriptorDir == null ? "conf" : this.descriptorDir;
    }

    public int getPort() {
        return this.port == null ? 8080 : Integer.parseInt(this.port);
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Override
    protected boolean execute() {
        try {
            if (this.warFile.exists() && !this.warFile.isDirectory()) {
                this.cleanWebRoot = true;
                this.webRoot = this.getWebroot();
                this.webRoot.mkdirs();
                ZipFile zipFile = new ZipFile(this.warFile.getAbsolutePath());
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    ZipHelper.unzipEntryToFolder((ZipEntry)entry, (InputStream)zipFile.getInputStream(entry), (File)this.getWebroot());
                }
                zipFile.close();
            } else {
                this.webRoot = this.warFile;
            }
            File staxWebXml = new File(this.getWebroot(), "WEB-INF/cloudbees-web.xml");
            if (!staxWebXml.exists()) {
                staxWebXml = new File(this.getWebroot(), "WEB-INF/stax-web.xml");
            }
            IAppServerConfiguration config = WarBasedServerConfiguration.load(null, (File)this.webRoot, (File)staxWebXml, (String[])this.getEnvironments(this.appConfig));
            this.getWorkDir().mkdirs();
            final StaxSdkAppServer server = new StaxSdkAppServer(new File(this.getTmpDir()).getAbsolutePath(), this.getWorkDir().getAbsolutePath(), this.getClass().getClassLoader(), new String[0], this.getPort(), config, null);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    server.stop();
                    if (ApplicationRun.this.cleanWebRoot) {
                        Helper.deleteDirectory(ApplicationRun.this.webRoot);
                    }
                }
            });
            server.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Application Run failure: " + e.getMessage(), e);
        }
        return true;
    }

    private String[] getEnvironments(File staxappxmlFile) {
        String envString = this.environment;
        if (envString == null || envString.equals("") && staxappxmlFile != null && staxappxmlFile.exists()) {
            AppConfig appConfig = new AppConfig();
            AppConfigHelper.load((AppConfig)appConfig, (String)staxappxmlFile.getAbsolutePath(), (String[])new String[0], (String[])new String[0]);
            envString = appConfig.getDefaultEnvironment();
        }
        String[] environment = ApplicationHelper.getEnvironmentList(envString, "run");
        return environment;
    }
}

